/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.monitor.timeout.service;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.timeout.service.DefaultLevelTimeoutInterrupter;
import kd.sdk.kingscript.monitor.timeout.service.LevelTimeoutInterrupter;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutInterrupter;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutInterrupterImpl;
import org.graalvm.polyglot.Context;
import org.slf4j.Logger;

final class TimeoutService {
    private static final Logger logger = Logs.getLogger();
    private static final TimeoutService service = new TimeoutService();
    private final Queue<TimeoutInterrupter> pending = new ConcurrentLinkedQueue<TimeoutInterrupter>();
    private final AtomicInteger seq = new AtomicInteger();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 8, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("KingScript-TimeoutInterrupter-" + this.seq.incrementAndGet());
        return t;
    });
    private final Object lock = new Object();
    private final Object heartbeat = new Object();
    private volatile long snoop = 1L;
    private volatile boolean withNew = false;

    TimeoutService() {
    }

    public static TimeoutInterrupter create(String engineName, Context context) {
        TimeoutInterrupterImpl ti = new TimeoutInterrupterImpl(engineName, context);
        service.add(ti);
        return ti;
    }

    public static LevelTimeoutInterrupter createLevelControl(String engineName, Context context, KingScriptEngineImpl engine) {
        LevelTimeoutInterrupter ti = new DefaultLevelTimeoutInterrupter();
        String className = "kd.bos.kingscript.console.control.LevelTimeoutInterrupterImpl";
        if (engine.getOptions().getDebugOptions().isEnabled()) {
            className = "kd.bos.kingscript.console.control.DebugLevelTimeoutInterrupterImpl";
        }
        try {
            Class<?> cls = Class.forName(className);
            Class[] parameterTypes = new Class[]{String.class, Context.class, KingScriptEngineImpl.class};
            Constructor<?> constructor = cls.getConstructor(parameterTypes);
            Object[] parameters = new Object[]{engineName, context, engine};
            ti = (LevelTimeoutInterrupter)constructor.newInstance(parameters);
            service.add(ti);
        }
        catch (Exception e) {
            logger.warn("Create monitor timeout interrupter failed: " + className + ", cause by" + e.getMessage(), (Throwable)e);
        }
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TimeoutInterrupter ti) {
        Object object = this.lock;
        synchronized (object) {
            this.pending.add(ti);
            this.withNew = true;
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wake() {
        Object object = this.heartbeat;
        synchronized (object) {
            this.heartbeat.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snoop() {
        Object object = this.heartbeat;
        synchronized (object) {
            try {
                this.heartbeat.wait(this.snoop);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void round() {
        long nextSnoop;
        if (this.pending.isEmpty()) {
            nextSnoop = 10000L;
        } else {
            nextSnoop = 100L;
            do {
                ArrayList<TimeoutInterrupter> list;
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    list = new ArrayList<TimeoutInterrupter>(this.pending);
                    this.withNew = false;
                }
                if (list.isEmpty()) continue;
                for (TimeoutInterrupter ti : list) {
                    long currentSnoop;
                    Object object;
                    if (!ti.isStartTiming()) continue;
                    this.pending.remove(ti);
                    try {
                        this.process(ti);
                    }
                    catch (Exception exception) {
                        object = this.lock;
                        synchronized (object) {
                            if (!ti.isDestroyed()) {
                                this.pending.add(ti);
                                currentSnoop = ti.remainTimeMillis();
                                if (currentSnoop <= 0L) {
                                    currentSnoop = ti.getTimeout();
                                }
                                if (currentSnoop > 0L && currentSnoop < nextSnoop) {
                                    nextSnoop = currentSnoop;
                                }
                            }
                        }
                    }
                    finally {
                        object = this.lock;
                        synchronized (object) {
                            if (!ti.isDestroyed()) {
                                this.pending.add(ti);
                                currentSnoop = ti.remainTimeMillis();
                                if (currentSnoop <= 0L) {
                                    currentSnoop = ti.getTimeout();
                                }
                                if (currentSnoop > 0L && currentSnoop < nextSnoop) {
                                    nextSnoop = currentSnoop;
                                }
                            }
                        }
                    }
                }
            } while (this.withNew);
        }
        this.snoop = nextSnoop;
    }

    private void process(TimeoutInterrupter ti) {
        this.executor.submit(ti);
    }

    private void start() {
        Thread thread = Thread.currentThread();
        while (!thread.isInterrupted()) {
            this.round();
            this.snoop();
        }
    }

    static {
        Thread t = new Thread(service::start);
        t.setDaemon(true);
        t.setName("KingScript-TimeoutService");
        t.start();
    }
}

