/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.pool;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.ModuleExports;
import kd.sdk.kingscript.engine.bindings.ScriptBindings;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.listener.EngineListener;
import kd.sdk.kingscript.pool.KingScriptEnginePool;

public final class KingScriptEngineProxy
implements KingScriptEngine {
    private KingScriptEngineImpl engine;
    private final KingScriptEnginePool pool;
    private long lastAccessTime;
    private boolean forceClose;
    private AtomicBoolean closed = new AtomicBoolean();
    private ScriptException closeStack;

    public KingScriptEngineProxy(KingScriptEngineImpl engine, KingScriptEnginePool pool) {
        this.engine = engine;
        this.pool = pool;
        this.lastAccessTime = System.currentTimeMillis();
        engine.setTopWrapper(this);
    }

    public KingScriptEngine getEngine() {
        return this.engine;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    private void debugHit() {
        if (this.engine == null && this.closeStack != null) {
            throw new ScriptException("KingScriptEngineProxy has been closed, close action stack is in this cause. @" + Thread.currentThread().getName(), this.closeStack);
        }
    }

    @Override
    public void enter() {
        this.debugHit();
        this.engine.enter();
    }

    @Override
    public void leave() {
        this.engine.leave();
    }

    @Override
    public ScriptBindings getBindings() {
        return this.engine.getBindings();
    }

    @Override
    public String load(String scriptPath) {
        return this.engine.load(scriptPath);
    }

    @Override
    public String ts2js(String ts) {
        try {
            String string = this.engine.ts2js(ts);
            return string;
        }
        finally {
            this.updateAccessTime();
        }
    }

    @Override
    public Object eval(String ts) {
        try {
            Object object = this.engine.eval(ts);
            return object;
        }
        finally {
            this.updateAccessTime();
        }
    }

    @Override
    public Object evalJavaScript(String js) {
        try {
            Object object = this.engine.evalJavaScript(js);
            return object;
        }
        finally {
            this.updateAccessTime();
        }
    }

    @Override
    public Object evalPath(String scriptPath) {
        try {
            Object object = this.engine.evalPath(scriptPath);
            return object;
        }
        finally {
            this.updateAccessTime();
        }
    }

    @Override
    public Object evalLib(String libPath) {
        try {
            Object object = this.engine.evalLib(libPath);
            return object;
        }
        finally {
            this.updateAccessTime();
        }
    }

    @Override
    public Map<String, List<String>> listModuleTypes(String ... modules) {
        return this.engine.listModuleTypes(modules);
    }

    @Override
    public ModuleExports listModuleExports(String ... modules) {
        return this.engine.listModuleExports(modules);
    }

    @Override
    public void addListener(EngineListener el) {
        this.engine.addListener(el);
    }

    @Override
    public void removeListener(EngineListener el) {
        this.engine.removeListener(el);
    }

    @Override
    public List<EngineListener> getListeners() {
        return this.engine.getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            return this.closed.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AtomicBoolean atomicBoolean = this.closed;
        synchronized (atomicBoolean) {
            if (!this.closed.get()) {
                this.engine.waitForClosed();
            }
            if (this.closed.compareAndSet(false, true)) {
                this.pool.release(this);
                this.engine = null;
                this.closeStack = new ScriptException("Close action stack @" + Thread.currentThread().getName());
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return (T)(cls == this.getClass() ? this : this.engine.unwrap(cls));
    }

    public void forceClose() {
        this.forceClose = true;
        this.close();
    }

    public boolean isForceClose() {
        return this.forceClose;
    }

    @Override
    public boolean isDebuggable() {
        return this.engine.isDebuggable();
    }

    @Override
    public String getDebugUrl() {
        return this.engine.getDebugUrl();
    }

    private void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String toString() {
        return this.engine.toString();
    }
}

