/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.security;

import com.oracle.truffle.js.runtime.util.LRUCache;
import java.util.Collections;
import java.util.Map;
import kd.sdk.kingscript.lib.ScriptInfo;
import kd.sdk.kingscript.security.DefaultSecurityController;
import kd.sdk.kingscript.security.IgnoreSecurityCheck;
import kd.sdk.kingscript.security.SecurityController;
import kd.sdk.kingscript.security.UnlimitSecurityController;

public final class CachedSecurityController
implements SecurityController {
    private static final CachedSecurityController DEFAULT_INSTANCE = new CachedSecurityController(DefaultSecurityController.INSTANCE);
    private final SecurityController sc;
    private Map<String, Boolean> booleanCache = Collections.synchronizedMap(new LRUCache(8192));

    public static SecurityController of(SecurityController sc) {
        if (sc == DefaultSecurityController.INSTANCE) {
            return DEFAULT_INSTANCE;
        }
        if (sc == UnlimitSecurityController.INSTANCE) {
            return sc;
        }
        return new CachedSecurityController(sc);
    }

    private CachedSecurityController(SecurityController sc) {
        this.sc = sc;
    }

    @Override
    public long getLimitMaxStatements() {
        return this.sc.getLimitMaxStatements();
    }

    @Override
    public boolean isLimitMaxStatements(String scriptPath) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return false;
        }
        String key = "A#" + scriptPath;
        Boolean b = this.booleanCache.get(key);
        if (b == null) {
            b = this.sc.isLimitMaxStatements(scriptPath);
            this.booleanCache.put(key, b);
        }
        return b;
    }

    @Override
    public boolean isThreadAccessAllowed(Thread thread) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return true;
        }
        return this.sc.isThreadAccessAllowed(thread);
    }

    @Override
    public long getScriptEvalTimeout() {
        return this.sc.getScriptEvalTimeout();
    }

    @Override
    public long getScriptEvalDebugTimeout() {
        return this.sc.getScriptEvalDebugTimeout();
    }

    @Override
    public boolean allowHostClassLookup(String className) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return true;
        }
        String key = "B#" + className;
        Boolean b = this.booleanCache.get(key);
        if (b == null) {
            b = this.sc.allowHostClassLookup(className);
            this.booleanCache.put(key, b);
        }
        return b;
    }

    @Override
    public boolean allowCreateHostObject(Class<?> cls) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return true;
        }
        String key = "C#" + cls.getName();
        Boolean b = this.booleanCache.get(key);
        if (b == null) {
            b = this.sc.allowCreateHostObject(cls);
            this.booleanCache.put(key, b);
        }
        return b;
    }

    @Override
    public boolean allowImportInternal(String scriptPath, String importInternalModulePath, ScriptInfo scriptInfo) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return true;
        }
        String key = "D#" + scriptPath + '#' + importInternalModulePath;
        Boolean b = this.booleanCache.get(key);
        if (b == null) {
            b = this.sc.allowImportInternal(scriptPath, importInternalModulePath, scriptInfo);
            this.booleanCache.put(key, b);
        }
        return b;
    }

    @Override
    public boolean allowUseConstructorType(String scriptPath, String className, ScriptInfo scriptInfo) {
        if (IgnoreSecurityCheck.isIgnoreSecurityCheck()) {
            return true;
        }
        String key = "E#" + scriptPath + '#' + className;
        Boolean b = this.booleanCache.get(key);
        if (b == null) {
            b = this.sc.allowUseConstructorType(scriptPath, className, scriptInfo);
            this.booleanCache.put(key, b);
        }
        return b;
    }
}

