/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kd.sdk.kingscript.engine.ContextBuilder;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.ScriptOptions;
import kd.sdk.kingscript.engine.storage.LocalStorage;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.transpiler.BabelTranspiler;
import kd.sdk.kingscript.transpiler.PluginAndPresetMode;
import kd.sdk.kingscript.transpiler.TransResult;
import kd.sdk.kingscript.transpiler.TranslationOptions;
import kd.sdk.kingscript.transpiler.TranspilerConst;
import kd.sdk.kingscript.transpiler.TranspilerEvalContext;
import kd.sdk.kingscript.transpiler.TranspilerThreadActor;
import kd.sdk.kingscript.transpiler.plugin.BabelPlugin;
import kd.sdk.kingscript.transpiler.preset.BabelPreset;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Source;
import org.slf4j.Logger;

final class BabelTranspilerImpl
implements BabelTranspiler {
    private static final Logger logger = Logs.getLogger();
    private static final AtomicInteger nameSeq = new AtomicInteger();
    private static Map<Engine, AtomicInteger> refCountMap = new ConcurrentHashMap<Engine, AtomicInteger>();
    private static volatile Engine sharedEngine;
    private final String name;
    private GraalJSScriptEngine scriptEngine;
    private Context context;
    private AtomicBoolean closed = new AtomicBoolean();
    private String optionsKey;
    private boolean supportEMS;
    private Source bableSource;
    private Source transSource;
    private Source debugTransSource;
    private List<Source> presetAndPluginList = new ArrayList<Source>();
    private boolean logEnabled;
    private final ReentrantLock lock = new ReentrantLock();

    static BabelTranspiler create(ScriptOptions options) {
        return TranspilerThreadActor.invoke(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    static BabelTranspiler create(BabelTranspiler protoTranspiler) {
        return TranspilerThreadActor.invoke(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearEngineCache() {
        sharedEngine = Engine.newBuilder().allowExperimentalOptions(true).build();
        Map<Engine, AtomicInteger> map = refCountMap;
        synchronized (map) {
            refCountMap.put(sharedEngine, new AtomicInteger());
        }
    }

    private BabelTranspilerImpl() {
        this.name = "ScriptTranspiler-" + nameSeq.incrementAndGet();
        Context.Builder ctxBuilder = ContextBuilder.createTranspilerContextBuilder();
        this.scriptEngine = GraalJSScriptEngine.create(sharedEngine, ctxBuilder);
        this.context = this.scriptEngine.getPolyglotContext();
        this.scriptEngine.getBindings(100).put("localStorage", (Object)new LocalStorage());
        refCountMap.get(sharedEngine).incrementAndGet();
    }

    private void initConfig(ScriptOptions options) {
        this.logEnabled = options.isLogEnabled();
        if (this.logEnabled) {
            logger.info("init " + this.name);
        }
        try {
            boolean minified;
            this.bableSource = Source.newBuilder((String)"js", (URL)BabelTranspilerImpl.class.getResource(TranspilerConst.asset_babel_min)).build();
            TranslationOptions transOptions = options.getTranslationOptions();
            this.optionsKey = transOptions.optionsKey(options.getDebugOptions().isEnabled()) + '#';
            this.supportEMS = transOptions.getTargetVersion().isSupportEMS();
            List<BabelPreset> presets = transOptions.getPresets();
            HashSet<Source> presetsAndPlugins = new HashSet<Source>(4);
            StringBuilder normal_presetNames = new StringBuilder(32);
            StringBuilder debug_presetNames = new StringBuilder(32);
            int n = presets.size();
            for (int i = 0; i < n; ++i) {
                Source source;
                BabelPreset preset = presets.get(i);
                PluginAndPresetMode mode = preset.getMode();
                if (mode == PluginAndPresetMode.NORMAL || mode == PluginAndPresetMode.BOTH) {
                    if (normal_presetNames.length() > 0) {
                        normal_presetNames.append(',');
                    }
                    normal_presetNames.append('\'').append(preset.getName()).append('\'');
                }
                if (mode == PluginAndPresetMode.DEBUG || mode == PluginAndPresetMode.BOTH) {
                    if (debug_presetNames.length() > 0) {
                        debug_presetNames.append(',');
                    }
                    debug_presetNames.append('\'').append(preset.getName()).append('\'');
                }
                if (!presetsAndPlugins.add(source = preset.getSource())) continue;
                this.presetAndPluginList.add(source);
            }
            List<BabelPlugin> plugins = transOptions.getPlugins();
            StringBuilder normal_pluginNames = new StringBuilder(32);
            StringBuilder debug_pluginNames = new StringBuilder(32);
            int n2 = plugins.size();
            for (int i = 0; i < n2; ++i) {
                Source source;
                BabelPlugin plugin = plugins.get(i);
                PluginAndPresetMode mode = plugin.getMode();
                if (mode == PluginAndPresetMode.NORMAL || mode == PluginAndPresetMode.BOTH) {
                    if (normal_pluginNames.length() > 0) {
                        normal_pluginNames.append(',');
                    }
                    normal_pluginNames.append('\'').append(plugin.getName()).append('\'');
                }
                if (mode == PluginAndPresetMode.DEBUG || mode == PluginAndPresetMode.BOTH) {
                    if (debug_pluginNames.length() > 0) {
                        debug_pluginNames.append(',');
                    }
                    debug_pluginNames.append('\'').append(plugin.getName()).append('\'');
                }
                if (!presetsAndPlugins.add(source = plugin.getSource())) continue;
                this.presetAndPluginList.add(source);
            }
            boolean debug = options.getDebugOptions().isEnabled();
            boolean bl = minified = !debug && transOptions.isMinified();
            if (normal_presetNames.length() > 0) {
                normal_presetNames.append(',');
            }
            normal_presetNames.append('\'').append(transOptions.getTargetVersion().getPreset()).append('\'');
            if (debug_presetNames.length() > 0) {
                debug_presetNames.append(',');
            }
            debug_presetNames.append('\'').append(transOptions.getTargetVersion().getPreset()).append('\'');
            this.transSource = this.buildSource(transOptions, normal_presetNames.toString(), normal_pluginNames.toString(), minified, false);
            this.debugTransSource = this.buildSource(transOptions, debug_presetNames.toString(), debug_pluginNames.toString(), minified, true);
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }

    private Source buildSource(TranslationOptions transOptions, String presetNames, String pluginNames, boolean minified, boolean debugMode) {
        if (debugMode) {
            minified = false;
        }
        String trans = "Babel.transform(__input__,{minified:" + minified + ",comments:false";
        trans = trans + ",presets:[" + presetNames + "]";
        if (pluginNames.length() > 0) {
            trans = trans + ",plugins:[" + pluginNames + "]";
        }
        if (transOptions.isGenAST()) {
            trans = trans + ",ast:true";
        }
        if (transOptions.isGenSourceMaps() || debugMode) {
            trans = trans + ",sourceMaps:true";
        }
        trans = trans + "})";
        return Source.newBuilder((String)"js", (CharSequence)trans, (String)"<eval>").buildLiteral();
    }

    private void initSource() {
        try {
            this.scriptEngine.eval2(this.bableSource, this.scriptEngine.getContext());
            for (Source source : this.presetAndPluginList) {
                this.scriptEngine.eval2(source, this.scriptEngine.getContext());
            }
        }
        catch (Exception e) {
            throw ScriptException.wrap(e);
        }
    }

    @Override
    public TransResult trans(KingScriptEngine executeEngine, String ts, boolean debugMode, boolean mappingSource) {
        if (this.closed.get()) {
            throw new ScriptException("Transpiler has closed.");
        }
        if (ts.startsWith("/*SKIP_TRANS*/")) {
            return TransResult.noTransResult(ts);
        }
        String tsKey = (debugMode ? (char)'1' : '0') + this.optionsKey + '#' + ts.length() + '#' + ts;
        Map<String, TransResult> cache = GlobalCache.get().getTranspilerCache();
        TransResult cached = cache.get(tsKey);
        if (cached != null) {
            return cached;
        }
        Map<String, String> env = TranspilerEvalContext.getEnv();
        return TranspilerThreadActor.invoke(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private String getTipScript(String script) {
        if (script.length() > 100) {
            int p = script.indexOf(10) - 1;
            if (p == -1 || p > 100) {
                p = 100;
            }
            script = script.substring(0, p) + " ...";
        }
        return script;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.logEnabled) {
                logger.info("close " + this.name);
            }
            TranspilerThreadActor.invoke(() -> {
                this.scriptEngine.close();
                Engine currentEngine = this.scriptEngine.getPolyglotEngine();
                Map<Engine, AtomicInteger> map = refCountMap;
                synchronized (map) {
                    AtomicInteger refCount = refCountMap.get(currentEngine);
                    int count = refCount.decrementAndGet();
                    if (count == 0 && currentEngine != sharedEngine) {
                        currentEngine.close();
                        refCountMap.remove(currentEngine);
                    }
                }
                this.scriptEngine = null;
                return null;
            });
        }
    }

    static {
        BabelTranspilerImpl.clearEngineCache();
    }
}

