/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.util.ConfigurationUtil;

final class TranspilerThreadActor {
    private static final AtomicInteger seq = new AtomicInteger();
    private static long threadXss = 0x100000L;
    private static final ThreadPoolExecutor executor;

    TranspilerThreadActor() {
    }

    private static void readThreadXss() {
        String xss = System.getProperty("kingscript.babeltranspiler.thread.xss");
        if (xss != null && xss.length() > 0) {
            try {
                threadXss = Long.parseLong(xss);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static <T> T invoke(Callable<T> call) {
        Future<T> future = executor.submit(call);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t != null) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            throw new RuntimeException(e);
        }
    }

    static {
        TranspilerThreadActor.readThreadXss();
        ConfigurationUtil.observeChange((String)"kingscript.babeltranspiler.thread.xss", (key, newValue) -> TranspilerThreadActor.readThreadXss());
        executor = new ThreadPoolExecutor(1, 50, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
            String threadName = "KingScript-" + TranspilerThreadActor.class.getSimpleName() + '-' + seq.incrementAndGet();
            Thread t = new Thread(null, r, threadName, threadXss);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
    }
}

