/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.model;

import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.transpiler.model.ConstructorTypeSegment;
import kd.sdk.kingscript.transpiler.model.ScriptImportSegment;
import kd.sdk.kingscript.transpiler.model.ScriptModel;
import kd.sdk.kingscript.transpiler.model.ScriptSegment;
import kd.sdk.kingscript.util.Tuple;

public final class ScriptModelParser {
    public static ScriptModel parse(String script) {
        ScriptModel sm = new ScriptModel();
        AtomicInteger lineCounter = new AtomicInteger();
        char[] chs = script.toCharArray();
        int n = chs.length;
        ScriptSegment seg = new ScriptSegment();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inBlockComment = false;
        boolean inLineComment = false;
        int i = -1;
        while (++i < n) {
            Tuple<Integer, ScriptSegment> tp;
            char ch = chs[i];
            if (inSingleQuote) {
                seg.append(ch);
                if (ch != '\'' || chs[i - 1] == '\\') continue;
                inSingleQuote = false;
                continue;
            }
            if (inDoubleQuote) {
                seg.append(ch);
                if (ch != '\"' || chs[i - 1] == '\\') continue;
                inDoubleQuote = false;
                continue;
            }
            if (inBlockComment) {
                seg.append(ch);
                if (ch != '*' || !ScriptModelParser.match(chs, i + 1, '/')) continue;
                seg.append(chs[++i]);
                inBlockComment = false;
                continue;
            }
            if (inLineComment) {
                seg.append(ch);
                if (ch != '\n') continue;
                inLineComment = false;
                lineCounter.incrementAndGet();
                continue;
            }
            if (ch == '\n') {
                seg.append(ch);
                lineCounter.incrementAndGet();
                continue;
            }
            if (ch == '\'') {
                seg.append(ch);
                inSingleQuote = true;
                continue;
            }
            if (ch == '\"') {
                seg.append(ch);
                inDoubleQuote = true;
                continue;
            }
            if (ch == '/') {
                seg.append(ch);
                if (ScriptModelParser.match(chs, i + 1, '/')) {
                    inLineComment = true;
                    seg.append(chs[++i]);
                    continue;
                }
                if (!ScriptModelParser.match(chs, i + 1, '*')) continue;
                inBlockComment = true;
                seg.append(chs[++i]);
                continue;
            }
            if (ch == 'i' && ScriptModelParser.match(chs, i + 1, "mport") && i + 6 < n && !Character.isAlphabetic(chs[i + 6])) {
                tp = ScriptModelParser.tryParseSegment(chs, ch, i, new ScriptImportSegment(lineCounter), seg, sm);
                i = tp.getKey();
                seg = tp.getValue();
                continue;
            }
            if (ch == ';') {
                seg.append(ch);
                if (!seg.isEmpty()) {
                    sm.addSegment(seg);
                }
                seg = new ScriptSegment();
                continue;
            }
            if (ch == '$') {
                tp = ScriptModelParser.tryParseSegment(chs, ch, i, new ConstructorTypeSegment(lineCounter), seg, sm);
                i = tp.getKey();
                seg = tp.getValue();
                continue;
            }
            seg.append(ch);
        }
        if (!seg.isEmpty()) {
            sm.addSegment(seg);
        }
        return sm;
    }

    private static Tuple<Integer, ScriptSegment> tryParseSegment(char[] chs, char ch, int i, ScriptSegment tryParseSeg, ScriptSegment currentSeg, ScriptModel sm) {
        int j = tryParseSeg.parse(chs, i);
        if (i == j) {
            currentSeg.append(ch);
        } else {
            if (!currentSeg.isEmpty()) {
                sm.addSegment(currentSeg);
            }
            i = j;
            sm.addSegment(tryParseSeg);
            currentSeg = new ScriptSegment();
        }
        return new Tuple<Integer, ScriptSegment>(i, currentSeg);
    }

    private static boolean match(char[] chs, int i, char ch) {
        return i < chs.length && chs[i] == ch;
    }

    private static boolean match(char[] chs, int i, String s) {
        return i + s.length() < chs.length && s.equals(new String(chs, i, s.length()));
    }
}

