/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.inherit.DummyInterface;

public final class BabelPluginContext {
    public static final String CONTEXT = "Context";
    private static final String namePrefix = "__";
    private final KingScriptEngine engine;
    private final String scriptPath;
    private final Map<String, List<ImportISpecifier>> importSpecifierMap = new HashMap<String, List<ImportISpecifier>>();
    private final Set<String> specifilerLocalNameSet = new HashSet<String>();
    private boolean importResolved;

    public BabelPluginContext(KingScriptEngine engine, String scriptPath) {
        this.engine = engine;
        this.scriptPath = scriptPath;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void watch(Object ... args) {
        System.out.println("[WATCH] " + Arrays.toString(args));
    }

    public void addImportSpecifier(String importStatement, String importedName, String localName) {
        ImportISpecifier specifier = new ImportISpecifier();
        specifier.isNamespace = importedName == null;
        specifier.localName = localName;
        this.importSpecifierMap.computeIfAbsent(importStatement, k -> new ArrayList()).add(specifier);
    }

    public boolean isJavaType(String typeName) {
        if (!this.importResolved && !this.importSpecifierMap.isEmpty()) {
            StringBuilder ts = new StringBuilder(256).append("/*SKIP_TRANS*/").append('\n');
            for (String string : this.importSpecifierMap.keySet()) {
                ts.append(string).append('\n');
            }
            HashSet<String> namespaceSet = new HashSet<String>();
            for (List<ImportISpecifier> list : this.importSpecifierMap.values()) {
                for (ImportISpecifier specifier : list) {
                    ts.append("export const ").append(namePrefix).append(specifier.localName).append("=(typeof ").append(specifier.localName).append("!='undefined')?").append(specifier.localName).append(":{}\n");
                    if (!specifier.isNamespace) continue;
                    namespaceSet.add(specifier.localName);
                }
            }
            Map map = (Map)this.engine.eval(ts.toString());
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == DummyInterface.class || value.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotMapAndFunction")) continue;
                String name = (String)entry.getKey();
                String localName = name.substring(namePrefix.length());
                if (namespaceSet.contains(localName)) {
                    Map nsMap = (Map)value;
                    for (Map.Entry nsEntry : nsMap.entrySet()) {
                        Object obj = nsEntry.getValue();
                        if (obj == DummyInterface.class || obj.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotMapAndFunction")) continue;
                        String objName = (String)nsEntry.getKey();
                        this.specifilerLocalNameSet.add(localName + '.' + objName);
                    }
                    continue;
                }
                this.specifilerLocalNameSet.add(localName);
            }
            this.importResolved = true;
        }
        return this.specifilerLocalNameSet.contains(typeName);
    }

    private static class ImportISpecifier {
        String localName;
        boolean isNamespace;

        private ImportISpecifier() {
        }
    }
}

