/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.sourcemap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.sdk.kingscript.transpiler.sourcemap.VLQ;
import kd.sdk.kingscript.util.Tuple;

public final class SourceMap {
    private Map<Integer, List<Tuple<Location, Location>>> source2targetMap = new HashMap<Integer, List<Tuple<Location, Location>>>();
    private Map<Integer, List<Tuple<Location, Location>>> target2sourceMap = new HashMap<Integer, List<Tuple<Location, Location>>>();
    private final String mappings;

    public static SourceMap decode(String mappings, boolean keepMappingString) {
        SourceMap sm = new SourceMap(keepMappingString ? mappings : null);
        int n = 0;
        int[] last = null;
        for (String line : mappings.split(";")) {
            for (String item : line.split(",")) {
                int[] decode = VLQ.decode(item);
                if (last != null) {
                    for (int i = 0; i < decode.length; ++i) {
                        int n2 = i;
                        decode[n2] = decode[n2] + last[i];
                    }
                }
                last = decode;
                Location source = new Location(decode[2], decode[3]);
                Location target = new Location(decode[1], decode[0]);
                sm.source2targetMap.computeIfAbsent(source.lineNumber, k -> new ArrayList()).add(new Tuple<Location, Location>(source, target));
                sm.target2sourceMap.computeIfAbsent(target.lineNumber, k -> new ArrayList()).add(new Tuple<Location, Location>(target, source));
            }
            if (last == null) continue;
            last[1] = ++n;
            last[0] = 0;
        }
        return sm;
    }

    public SourceMap(String mappings) {
        this.mappings = mappings;
    }

    public Location getTargetLocation(Location sourceLocation) {
        List<Tuple<Location, Location>> tuples = this.source2targetMap.get(sourceLocation.lineNumber);
        if (tuples != null) {
            for (Tuple<Location, Location> tp : tuples) {
                if (tp.getKey().columnNumber < sourceLocation.columnNumber) continue;
                return tp.getValue();
            }
        }
        return null;
    }

    public Location getSourceLocation(Location targetLocation) {
        List<Tuple<Location, Location>> tuples = this.target2sourceMap.get(targetLocation.lineNumber);
        if (tuples != null) {
            for (Tuple<Location, Location> tp : tuples) {
                if (tp.getKey().columnNumber < targetLocation.columnNumber) continue;
                return tp.getValue();
            }
        }
        return targetLocation;
    }

    public String getMappings() {
        return this.mappings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        int n = 0;
        for (List<Tuple<Location, Location>> lines : new TreeMap<Integer, List<Tuple<Location, Location>>>(this.source2targetMap).values()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(n).append(") ");
            int i = 0;
            for (Tuple<Location, Location> value : lines) {
                if (i > 0) {
                    sb.append("  |  ");
                }
                sb.append(value.getKey()).append("=>").append(value.getValue());
                ++i;
            }
            ++n;
        }
        return sb.toString();
    }

    public static class Location {
        private final int lineNumber;
        private final int columnNumber;

        public Location(int lineNumber, int columnNumber) {
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public String toString() {
            return '[' + String.valueOf(this.lineNumber) + ',' + this.columnNumber + ']';
        }
    }
}

