/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.transpiler.sourcemap;

import java.util.HashMap;
import java.util.Map;

final class VLQ {
    private static final Map<Character, Integer> char_to_integer = new HashMap<Character, Integer>();
    private static final Map<Integer, Character> integer_to_char = new HashMap<Integer, Character>();

    VLQ() {
    }

    static int[] decode(String string) {
        int index = 0;
        int[] result = new int[5];
        int shift = 0;
        int value = 0;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Integer integer = char_to_integer.get(Character.valueOf(string.charAt(i)));
            if (integer == null) {
                throw new IllegalArgumentException("Invalid character (" + string.charAt(i) + ")");
            }
            int has_continuation_bit = integer & 0x20;
            integer = integer & 0x1F;
            value += integer << shift;
            if (has_continuation_bit != 0) {
                shift += 5;
                continue;
            }
            int should_negate = value & 1;
            value >>>= 1;
            if (should_negate != 0) {
                result[index++] = value == 0 ? Integer.MIN_VALUE : -value;
            } else {
                result[index++] = value;
            }
            shift = 0;
            value = 0;
        }
        return result;
    }

    static String encode(int[] nums) {
        StringBuilder result = new StringBuilder(5 * nums.length);
        for (int num : nums) {
            VLQ.encode(num, result);
        }
        return result.toString();
    }

    static String encode(int num) {
        StringBuilder result = new StringBuilder(5);
        VLQ.encode(num, result);
        return result.toString();
    }

    private static void encode(int num, StringBuilder result) {
        num = num < 0 ? -num << 1 | 1 : (num <<= 1);
        do {
            int clamped = num & 0x1F;
            if ((num >>>= 5) > 0) {
                clamped |= 0x20;
            }
            result.append(integer_to_char.get(clamped));
        } while (num > 0);
    }

    static {
        char[] chs = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        int i = 0;
        for (char ch : chs) {
            char_to_integer.put(Character.valueOf(ch), i);
            integer_to_char.put(i, Character.valueOf(ch));
            ++i;
        }
    }
}

