/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.ScriptValue;
import kd.sdk.kingscript.types.Types;
import org.graalvm.polyglot.Value;

public final class ScriptValueImpl
implements ScriptValue {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Value jsValue;

    public static ScriptValue create(Value value) {
        return value == null ? null : new ScriptValueImpl(value);
    }

    private ScriptValueImpl(Value jsValue) {
        this.jsValue = jsValue;
    }

    public Object getJsValue() {
        return this.jsValue;
    }

    @Override
    public Map<String, Object> toMap() {
        Set keys = this.jsValue.getMemberKeys();
        HashMap<String, Object> map = new HashMap<String, Object>((int)((double)keys.size() / 0.75));
        for (String key : keys) {
            map.put(key, this.jsValue.getMember(key));
        }
        return map;
    }

    @Override
    public ScriptValue getMember(String identifier) {
        return ScriptValueImpl.create(this.jsValue.getMember(identifier));
    }

    @Override
    public boolean hasMembers() {
        return this.jsValue.hasMembers();
    }

    @Override
    public Set<String> getMemberKeys() {
        return this.jsValue.getMemberKeys();
    }

    @Override
    public boolean hasMember(String identifier) {
        return this.jsValue.hasMember(identifier);
    }

    @Override
    public void putMember(String identifier, Object value) {
        this.jsValue.putMember(identifier, value);
    }

    @Override
    public boolean removeMember(String identifier) {
        return this.jsValue.removeMember(identifier);
    }

    @Override
    public boolean canExecute() {
        return this.jsValue.canExecute();
    }

    @Override
    public ScriptValue execute(Object ... arguments) {
        try {
            return ScriptValueImpl.create(this.jsValue.execute(this.java2js(arguments)));
        }
        catch (Throwable e) {
            throw ScriptException.wrap(e);
        }
    }

    @Override
    public void executeVoid(Object ... arguments) {
        try {
            this.jsValue.executeVoid(this.java2js(arguments));
        }
        catch (Throwable e) {
            throw ScriptException.wrap(e);
        }
    }

    private Object[] java2js(Object ... arguments) {
        if (arguments == null) {
            return EMPTY_ARGS;
        }
        Object[] ret = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            ret[i] = Types.java2js(arguments[i]);
        }
        return ret;
    }

    @Override
    public <T> T as(Class<T> targetType) {
        return (T)this.jsValue.as(targetType);
    }

    @Override
    public Object asJavaObject() {
        return Types.js2java(this.jsValue);
    }

    @Override
    public Object[] asArray() {
        int n = (int)this.jsValue.getArraySize();
        Object[] ret = new Object[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = Types.js2java(this.jsValue.getArrayElement((long)i));
        }
        return ret;
    }

    @Override
    public boolean isBoolean() {
        return this.jsValue.isBoolean();
    }

    @Override
    public boolean asBoolean() {
        return this.jsValue.asBoolean();
    }
}

