/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.annotation.SdkScriptWrapper;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.monitor.cost.Cost;
import kd.sdk.kingscript.types.ScriptObject;
import kd.sdk.kingscript.types.adapter.config.TypeAdapterConfig;
import kd.sdk.kingscript.types.adapter.config.TypeAdapterConfigItem;
import kd.sdk.kingscript.types.wrapper.DynamicScriptProxyWrapper;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;

public final class TypeAdapters {
    private static final AtomicBoolean loaded = new AtomicBoolean();
    private static final Logger logger = Logs.getLogger();

    public static void setup(Map<Class, TypeAdapterConfigItem> wrapItemMap, List<Class> wrapClassList, List<TypeAdapterConfigItem> adapterConfigItems) {
        if (loaded.compareAndSet(false, true)) {
            HashMap<Class, Class> definedTypeMap = new HashMap<Class, Class>();
            HashMap<Class, TypeAdapterConfig> adaptedTACMap = new HashMap<Class, TypeAdapterConfig>();
            ArrayList<TypeAdapterConfig> spiList = new ArrayList<TypeAdapterConfig>();
            ServiceLoader<TypeAdapterConfig> sl = ServiceLoader.load(TypeAdapterConfig.class);
            Iterator<TypeAdapterConfig> iterator = sl.iterator();
            while (iterator.hasNext()) {
                spiList.add(iterator.next());
            }
            spiList.sort(Comparator.comparingInt(t -> t.level().ordinal()));
            for (TypeAdapterConfig currentTAC : spiList) {
                List configItems = currentTAC.getConfigItems();
                logger.debug("[TypeAdapterConfig-" + (Object)((Object)currentTAC.level()) + "] " + currentTAC.getClass().getName() + " config item: " + (configItems == null ? 0 : configItems.size()));
                if (configItems == null || configItems.isEmpty()) continue;
                for (TypeAdapterConfigItem item : configItems) {
                    Class sourceType = item.getSourceType();
                    Class adaptedTargetType = (Class)definedTypeMap.get(sourceType);
                    if (adaptedTargetType != null && adaptedTargetType != item.getTargetType()) {
                        TypeAdapterConfig alreadyDefineTAC = (TypeAdapterConfig)adaptedTACMap.get(sourceType);
                        throw new ScriptException("[TypeAdapterConfig] duplicate define " + sourceType.getName() + " wrapper: " + adaptedTargetType.getName() + "@" + alreadyDefineTAC + " and " + item.getTargetType().getName() + "@" + currentTAC);
                    }
                    adaptedTACMap.put(sourceType, currentTAC);
                    wrapItemMap.put(sourceType, item);
                    adapterConfigItems.add(item);
                    wrapClassList.add(sourceType);
                    definedTypeMap.put(sourceType, item.getTargetType());
                    String msg = "[Encapsulated]" + sourceType.getName() + " -> " + item.getTargetType().getName();
                    if (sourceType == item.getTargetType()) {
                        msg = "[Functional]" + sourceType.getName();
                    }
                    logger.debug("[TypeAdapterConfig] " + msg);
                }
            }
            HashSet<String> scanedSet = new HashSet<String>();
            for (TypeAdapterConfig currentTAC : spiList) {
                Object[] packages = currentTAC.getAutoAdaptPackagePrefixes();
                if (packages == null) {
                    packages = new String[]{};
                }
                ArrayList<String> tobeScanList = new ArrayList<String>(packages.length);
                for (String string : packages) {
                    if (!scanedSet.add(string)) continue;
                    tobeScanList.add(string);
                }
                logger.debug("[AutoMappingType-" + (Object)((Object)currentTAC.level()) + "] " + currentTAC.getClass().getName() + " scan packages: " + Arrays.toString(packages) + "->" + tobeScanList);
                if (tobeScanList.isEmpty()) continue;
                List<TypeAdapterConfigItem> items = TypeAdapters.collectAutoAdaptedItems(definedTypeMap, adaptedTACMap, currentTAC, tobeScanList.toArray(new String[tobeScanList.size()]));
                for (TypeAdapterConfigItem item : items) {
                    Class clazz = item.getSourceType();
                    adaptedTACMap.put(clazz, currentTAC);
                    wrapItemMap.put(clazz, item);
                    adapterConfigItems.add(item);
                    wrapClassList.add(clazz);
                    definedTypeMap.put(clazz, item.getTargetType());
                    String msg = "[Encapsulated]" + clazz.getName() + " -> " + item.getTargetType().getName();
                    if (clazz == item.getTargetType()) {
                        msg = "[Functional]" + clazz.getName();
                    }
                    logger.debug("[AutoMappingType] " + msg);
                }
            }
        }
    }

    public static Method getSdkScriptWrapperSharedOfMethod(Class<?> scriptObjectType) {
        SdkScriptWrapper sdkScriptWrapper = scriptObjectType.getAnnotation(SdkScriptWrapper.class);
        if (sdkScriptWrapper != null) {
            if (!ScriptObject.class.isAssignableFrom(scriptObjectType)) {
                throw new ScriptException("[AutoMappingType] " + scriptObjectType.getName() + " non compliant definition, interface not implemented: " + ScriptObject.class.getName());
            }
            Class sourceType = sdkScriptWrapper.javaType();
            if (sourceType == scriptObjectType || sourceType == Object.class) {
                return null;
            }
            return TypeAdapters.getSharedOfMethod(scriptObjectType, sourceType, sdkScriptWrapper.sharedOf());
        }
        return null;
    }

    private static Method getSharedOfMethod(Class<?> targetType, Class<?> sourceType, String sharedOf) {
        try {
            Method method = targetType.getMethod(sharedOf, sourceType);
            if (method != null && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            for (Method method : targetType.getMethods()) {
                if (!sharedOf.equals(method.getName()) || method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || !method.getParameterTypes()[0].isAssignableFrom(sourceType)) continue;
                return method;
            }
        }
        return null;
    }

    public static boolean isWrapSelfObjectType(Object object) {
        Class<?> cls = object.getClass();
        do {
            if (TypeAdapters.isWrapSelfObjectType(cls)) continue;
            return false;
        } while ((cls = cls.getSuperclass()) != Object.class);
        return true;
    }

    public static boolean isWrapSelfObjectType(Class<?> objectType) {
        SdkScriptWrapper sdkScriptWrapper = objectType.getAnnotation(SdkScriptWrapper.class);
        if (sdkScriptWrapper != null) {
            Class sourceType = sdkScriptWrapper.javaType();
            return sourceType == objectType || sourceType == Object.class;
        }
        return true;
    }

    private static List<TypeAdapterConfigItem> collectAutoAdaptedItems(Map<Class, Class> definedTypeMap, Map<Class, TypeAdapterConfig> definedTACMap, TypeAdapterConfig currentTAC, String ... packages) {
        try (Cost cost = Collector.cost("TypeAdapters.collectAutoAdaptedItems", currentTAC.getClass().getName()).logOnClose();){
            ArrayList<TypeAdapterConfigItem<Object, Object>> adapters = new ArrayList<TypeAdapterConfigItem<Object, Object>>();
            Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(packages).filterInputsBy(file -> file.endsWith(".class")).setScanners(new Scanner[]{Scanners.TypesAnnotated}));
            TreeSet<Class> set = new TreeSet<Class>(Comparator.comparing(Class::getName));
            set.addAll(reflections.getTypesAnnotatedWith(SdkScriptWrapper.class));
            for (Class targetType : set) {
                SdkScriptWrapper sdkScriptWrapper = targetType.getAnnotation(SdkScriptWrapper.class);
                if (sdkScriptWrapper == null) continue;
                if (!ScriptObject.class.isAssignableFrom(targetType)) {
                    throw new ScriptException("[AutoMappingType] " + targetType.getName() + " non compliant definition, interface not implemented: " + ScriptObject.class.getName());
                }
                Class sourceType = sdkScriptWrapper.javaType();
                if (!Modifier.isPublic(targetType.getModifiers()) || Modifier.isAbstract(targetType.getModifiers())) {
                    logger.debug("[No mapping required] [not implement]" + targetType.getName());
                    continue;
                }
                Class definedTargetType = definedTypeMap.get(sourceType);
                if (definedTargetType != null && definedTargetType != targetType) {
                    TypeAdapterConfig alreadyDefineTAC = definedTACMap.get(sourceType);
                    throw new ScriptException("[AutoMappingType] duplicate define " + sourceType.getName() + " wrapper: " + definedTargetType.getName() + "@" + alreadyDefineTAC + " and " + targetType.getName() + "@" + currentTAC);
                }
                boolean wrapSelf = sourceType == targetType || sourceType == Object.class;
                String sharedOf = sdkScriptWrapper.sharedOf();
                try {
                    TypeAdapterConfigItem<Object, Object> adapterItem;
                    Method method = TypeAdapters.getSharedOfMethod(targetType, sourceType, sharedOf);
                    if (method != null) {
                        if (wrapSelf) {
                            throw new ScriptException("[AutoMappingType] defined " + sharedOf + " method, but @SdkScriptObject need to specify javaType(can't be " + Object.class.getSimpleName() + " and " + targetType.getSimpleName() + "): " + targetType.getName() + "@" + currentTAC);
                        }
                        method.setAccessible(true);
                        adapterItem = new TypeAdapterConfigItem<Object, Object>(sourceType, targetType, sdkScriptWrapper.includeSubTypes(), obj -> {
                            try {
                                return method.invoke(null, obj);
                            }
                            catch (Exception e) {
                                throw ScriptException.wrap(e);
                            }
                        });
                        adapters.add(adapterItem);
                        continue;
                    }
                    if (wrapSelf) {
                        sourceType = targetType;
                        adapterItem = new TypeAdapterConfigItem<Object, Object>(sourceType, targetType, sdkScriptWrapper.includeSubTypes(), obj -> {
                            try {
                                return DynamicScriptProxyWrapper.wrap(obj);
                            }
                            catch (Exception e) {
                                throw ScriptException.wrap(e);
                            }
                        });
                        adapters.add(adapterItem);
                        continue;
                    }
                    logger.warn("[AutoMappingType] ignore " + targetType.getName() + ", undefine wrapper method: public static " + targetType.getSimpleName() + " " + sharedOf + "(" + sourceType.getSimpleName() + ")");
                }
                catch (Exception e) {
                    logger.warn("[AutoMappingType] ignore " + targetType.getName() + ", undefine wrapper method: public static " + targetType.getSimpleName() + " " + sharedOf + "(" + sourceType.getSimpleName() + ")");
                }
            }
            ArrayList<TypeAdapterConfigItem<Object, Object>> arrayList = adapters;
            return arrayList;
        }
    }
}

