/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.builtins;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import kd.sdk.annotation.SdkScriptBound;
import kd.sdk.annotation.SdkScriptWrapper;
import kd.sdk.kingscript.types.Types;
import kd.sdk.kingscript.types.builtins.ScriptDateFormat;
import kd.sdk.kingscript.types.wrapper.ScriptProxyWrapper;
import kd.sdk.kingscript.util.ImmutableSet;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;

@SdkScriptBound(value="/resources/asset/engine/initialize_script.js")
@SdkScriptWrapper(scriptName="Date", javaType=Date.class)
public final class ScriptDate
implements ScriptProxyWrapper<Date> {
    private static final Set<String> PROTOTYPE_FUNCTIONS = ImmutableSet.of("toString", "toDateString", "toLocaleDateString", "toTimeString", "toLocaleTimeString", "toLocaleString", "valueOf", "getTime", "getFullYear", "getUTCFullYear", "getMonth", "getUTCMonth", "getDate", "getUTCDate", "getDay", "getUTCDay", "getHours", "getUTCHours", "getMinutes", "getUTCMinutes", "getSeconds", "getUTCSeconds", "getMilliseconds", "getUTCMilliseconds", "getTimezoneOffset", "setTime", "setMilliseconds", "setUTCMilliseconds", "setSeconds", "setUTCSeconds", "setMinutes", "setUTCMinutes", "setHours", "setUTCHours", "setDate", "setUTCDate", "setMonth", "setUTCMonth", "setFullYear", "setUTCFullYear", "toUTCString", "toISOString", "toJSON", "compareTo");
    private final Date date;
    private transient Calendar cstCalendar;
    private transient Calendar utcCalendar;

    public static ScriptDate sharedOf(Date data) {
        return new ScriptDate(data);
    }

    public static long parse(String s) {
        return ScriptDate.parseDate(s).getTime();
    }

    public static long UTC(int year, int monthIndex, Integer date, Integer hours, Integer minutes, Integer seconds, Integer ms) {
        return ScriptDate.ofTimeInMillis(true, year, monthIndex, date, hours, minutes, seconds, ms);
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    private static long ofTimeInMillis(boolean utc, int year, int monthIndex, Integer date, Integer hours, Integer minutes, Integer seconds, Integer ms) {
        Calendar cc = Calendar.getInstance();
        if (utc) {
            cc.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        cc.set(1, year);
        cc.set(2, monthIndex);
        if (date != null) {
            cc.set(5, date);
        }
        if (hours != null) {
            cc.set(11, hours);
        }
        if (minutes != null) {
            cc.set(12, minutes);
        }
        if (seconds != null) {
            cc.set(13, seconds);
        }
        if (ms != null) {
            cc.set(14, ms);
        }
        return cc.getTimeInMillis();
    }

    private static Date parseDate(String s) {
        int len = s.length();
        String pattern = len <= 10 ? "yyyy-MM-dd" : (len <= 19 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS");
        return ScriptDateFormat.parse(s, pattern);
    }

    public ScriptDate() {
        this(new Date());
    }

    public ScriptDate(String s) {
        this(ScriptDate.parseDate(s));
    }

    public ScriptDate(Date date) {
        this.date = date;
    }

    public ScriptDate(long ts) {
        this.date = new Date(ts);
    }

    public ScriptDate(int year, int monthIndex, Integer date, Integer hours, Integer minutes, Integer seconds, Integer ms) {
        this.date = new Date(ScriptDate.ofTimeInMillis(false, year, monthIndex, date, hours, minutes, seconds, ms));
    }

    @Override
    public Date unwrap() {
        return this.date;
    }

    private Calendar getCalendar(boolean utc) {
        if (utc) {
            if (this.utcCalendar == null) {
                this.utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            }
            return this.utcCalendar;
        }
        if (this.cstCalendar == null) {
            this.cstCalendar = Calendar.getInstance();
        }
        return this.cstCalendar;
    }

    private int getField(boolean utc, int field) {
        Calendar cc = this.getCalendar(utc);
        cc.setTime(this.date);
        return cc.get(field);
    }

    private <R> R setField(boolean utc, Function<Calendar, R> setFunc) {
        Calendar cc = this.getCalendar(utc);
        cc.setTime(this.date);
        R ret = setFunc.apply(cc);
        this.date.setTime(cc.getTimeInMillis());
        return ret;
    }

    public Object getMember(String key) {
        boolean utc = key.contains("UTC");
        switch (key) {
            case "toString": {
                return arguments -> this.date.toString();
            }
            case "toDateString": 
            case "toLocaleDateString": {
                return arguments -> ScriptDateFormat.format(this.date, "yyyy-MM-dd");
            }
            case "toTimeString": 
            case "toLocaleTimeString": {
                return arguments -> ScriptDateFormat.format(this.date, "HH:mm:ss");
            }
            case "toLocaleString": {
                return arguments -> ScriptDateFormat.format(this.date, "yyyy-MM-dd HH:mm:ss.SSS");
            }
            case "valueOf": 
            case "getTime": {
                return arguments -> this.date.getTime();
            }
            case "getFullYear": 
            case "getUTCFullYear": {
                return arguments -> this.getField(utc, 1);
            }
            case "getMonth": 
            case "getUTCMonth": {
                return arguments -> this.getField(utc, 2);
            }
            case "getDate": 
            case "getUTCDate": {
                return arguments -> this.getField(utc, 5);
            }
            case "getDay": 
            case "getUTCDay": {
                return arguments -> this.getField(utc, 5);
            }
            case "getHours": 
            case "getUTCHours": {
                return arguments -> this.getField(utc, 11);
            }
            case "getMinutes": 
            case "getUTCMinutes": {
                return arguments -> this.getField(utc, 12);
            }
            case "getSeconds": 
            case "getUTCSeconds": {
                return arguments -> this.getField(utc, 13);
            }
            case "getMilliseconds": 
            case "getUTCMilliseconds": {
                return arguments -> this.getField(utc, 14);
            }
            case "getTimezoneOffset": {
                return arguments -> this.getField(utc, 15);
            }
            case "setTime": 
            case "setMilliseconds": 
            case "setUTCMilliseconds": {
                return arguments -> this.setField(utc, cc -> {
                    long ms = arguments[0].asLong();
                    cc.setTimeInMillis(ms);
                    return ms;
                });
            }
            case "setSeconds": 
            case "setUTCSeconds": {
                return arguments -> this.setField(utc, cc -> {
                    int seconds = arguments[0].asInt();
                    cc.set(13, seconds);
                    if (arguments.length > 1) {
                        int ms = arguments[1].asInt();
                        cc.set(14, ms);
                    }
                    return cc.getTimeInMillis();
                });
            }
            case "setMinutes": 
            case "setUTCMinutes": {
                return arguments -> this.setField(utc, cc -> {
                    int minutes = arguments[0].asInt();
                    cc.set(12, minutes);
                    if (arguments.length > 1) {
                        int seconds = arguments[1].asInt();
                        cc.set(13, seconds);
                        if (arguments.length > 2) {
                            int ms = arguments[2].asInt();
                            cc.set(14, ms);
                        }
                    }
                    return cc.getTimeInMillis();
                });
            }
            case "setHours": 
            case "setUTCHours": {
                return arguments -> this.setField(utc, cc -> {
                    int hours = arguments[0].asInt();
                    cc.set(11, hours);
                    if (arguments.length > 1) {
                        int minutes = arguments[1].asInt();
                        cc.set(12, minutes);
                        if (arguments.length > 2) {
                            int seconds = arguments[2].asInt();
                            cc.set(13, seconds);
                            if (arguments.length > 3) {
                                int ms = arguments[3].asInt();
                                cc.set(14, ms);
                            }
                        }
                    }
                    return cc.getTimeInMillis();
                });
            }
            case "setDate": 
            case "setUTCDate": {
                return arguments -> this.setField(utc, cc -> {
                    int date = arguments[0].asInt();
                    cc.set(5, date);
                    return cc.getTimeInMillis();
                });
            }
            case "setMonth": 
            case "setUTCMonth": {
                return arguments -> this.setField(utc, cc -> {
                    int month = arguments[0].asInt();
                    cc.set(2, month);
                    return cc.getTimeInMillis();
                });
            }
            case "setFullYear": 
            case "setUTCFullYear": {
                return arguments -> this.setField(utc, cc -> {
                    int year = arguments[0].asInt();
                    cc.set(1, year);
                    return cc.getTimeInMillis();
                });
            }
            case "toUTCString": 
            case "toISOString": 
            case "toJSON": {
                return arguments -> ScriptDateFormat.format(this.date, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            }
            case "compareTo": {
                return arguments -> this.date.compareTo((Date)Types.js2java(arguments[0]));
            }
        }
        throw new UnsupportedOperationException("Date not support: " + key);
    }

    public Object getMemberKeys() {
        return PROTOTYPE_FUNCTIONS.toArray();
    }

    public boolean hasMember(String key) {
        return PROTOTYPE_FUNCTIONS.contains(key);
    }

    @Override
    public void putMember(String key, Value value) {
        ProxyExecutable member = (ProxyExecutable)this.getMember(key);
        member.execute(new Value[]{value});
    }

    public String toString() {
        return this.date.toString();
    }
}

