/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.types.builtins;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.ScriptObject;

public final class ScriptDateFormat
implements ScriptObject {
    private static final ThreadLocal<Map<String, SimpleDateFormat>> th = new ThreadLocal();

    private ScriptDateFormat() {
    }

    public static String format(Date date, String pattern) {
        return ScriptDateFormat.getSDF(pattern).format(date);
    }

    public static Date parse(String value, String pattern) {
        try {
            return ScriptDateFormat.getSDF(pattern).parse(value);
        }
        catch (ParseException e) {
            throw new ScriptException(e);
        }
    }

    private static SimpleDateFormat getSDF(String pattern) {
        Map<String, SimpleDateFormat> map = th.get();
        SimpleDateFormat sdf = null;
        if (map == null) {
            map = new HashMap<String, SimpleDateFormat>();
            th.set(map);
        } else {
            sdf = map.get(pattern);
        }
        if (sdf == null) {
            sdf = new SimpleDateFormat(pattern);
            map.put(pattern, sdf);
        }
        return sdf;
    }
}

