/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class FileUtil {
    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void save(String path, String content) {
        try {
            File parentFile = new File(path).getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            Files.write(Paths.get(path, new String[0]), content.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readResource(String resourcePath) {
        try (InputStream is = FileUtil.class.getResourceAsStream(resourcePath);){
            String string = FileUtil.readString(is);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readString(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        return os.toString("UTF-8");
    }

    public static String readString(Path path) throws IOException {
        try (FileInputStream is = new FileInputStream(path.toFile());){
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            String string = os.toString("UTF-8");
            return string;
        }
    }

    public static void collectFiles(File root, List<File> ret, FileFilter fileFilter) {
        if (root.isFile()) {
            if (fileFilter.accept(root)) {
                ret.add(root);
            }
        } else {
            for (File file : root.listFiles()) {
                FileUtil.collectFiles(file, ret, fileFilter);
            }
        }
    }
}

