/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.util;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtil {
    private static final AtomicInteger seq = new AtomicInteger();
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("KingScript-Common-" + seq.incrementAndGet());
        return t;
    });

    public static void start(Runnable runnable) {
        executor.submit(() -> {
            Thread th = Thread.currentThread();
            String name = th.getName();
            try {
                runnable.run();
            }
            finally {
                if (!name.equals(th.getName())) {
                    th.setName(name);
                }
            }
        });
    }

    public static ThreadNameMarker markName(String namePrefix) {
        return new ThreadNameMarker(namePrefix);
    }

    public static final class ThreadNameMarker
    implements AutoCloseable {
        private final String namePrefix;
        private final Thread th;

        private ThreadNameMarker(String namePrefix) {
            this.namePrefix = namePrefix;
            this.th = Thread.currentThread();
            this.th.setName(namePrefix + this.th.getName());
        }

        @Override
        public void close() {
            if (this.th.getName().startsWith(this.namePrefix)) {
                this.th.setName(this.th.getName().substring(this.namePrefix.length()));
            }
        }
    }
}

