/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.broadcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mservice.monitor.ServiceInfoManger;

public class BroadcastDispatchServiceHelper {
    private static Log log = LogFactory.getLog(BroadcastDispatchServiceHelper.class);

    public static int broadcast(String className, String methodName, Object ... paras) {
        int total = 0;
        int success = 0;
        List serviceInfos = ServiceInfoManger.getInstance().getServiceList();
        for (ServiceInfo serviceInfo : serviceInfos) {
            String nodeIp = serviceInfo.getIp();
            ++total;
            try {
                EndPointDispatchServiceHelper.invoke(nodeIp, className, methodName, paras);
                ++success;
            }
            catch (Exception e) {
                log.error("broadcast {} fail", (Object)nodeIp, (Object)e);
            }
        }
        return BroadcastDispatchServiceHelper.dealResult(total, success);
    }

    public static int broadcastPointAppId(String appId, String className, String methodName, Object ... paras) {
        int total = 0;
        int success = 0;
        List serviceInfos = ServiceInfoManger.getInstance().getServiceList();
        for (ServiceInfo serviceInfo : serviceInfos) {
            String nodeIp = serviceInfo.getIp();
            try {
                ArrayList appIdList;
                String[] appIds = serviceInfo.getAppIds();
                ArrayList arrayList = appIdList = appIds != null ? Arrays.asList(appIds) : new ArrayList();
                if (!Instance.isAppSplit() || Instance.isAppSplit() && appIdList.contains(appId)) {
                    ++total;
                    EndPointDispatchServiceHelper.invoke(nodeIp, className, methodName, paras);
                }
                ++success;
            }
            catch (Exception e) {
                log.error("broadcast {} fail", (Object)nodeIp, (Object)e);
            }
        }
        return BroadcastDispatchServiceHelper.dealResult(total, success);
    }

    private static int dealResult(int total, int success) {
        if (total != 0 && total == success) {
            return 1;
        }
        if (total == 0 || success == 0) {
            return -1;
        }
        return 0;
    }
}

