/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.config;

import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.LockSupport;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MserviceAssemblyConfig {
    private static final Logger log = LoggerFactory.getLogger(MserviceAssemblyConfig.class);
    public static String MSERVICE_BOOTER_TYPE;
    public static String MSERVICE_RPC_TYPE;
    public static String MSERVICE_DISCOVERY_TYPE;

    public static void init() {
        Map<String, String> config = MserviceAssemblyConfig.getConfig();
        MSERVICE_BOOTER_TYPE = System.getProperty("mservice.booter.type");
        if (StringUtils.isEmpty((String)MSERVICE_BOOTER_TYPE)) {
            MSERVICE_BOOTER_TYPE = config.get("mservice.booter.type");
        }
        if (StringUtils.isEmpty((String)(MSERVICE_RPC_TYPE = System.getProperty("mservice.rpc.type")))) {
            MSERVICE_RPC_TYPE = config.get("mservice.rpc.type");
        }
        if ("feign".equals(MSERVICE_RPC_TYPE)) {
            System.setProperty("SERVICE_PORT", WebPortUtil.getWebPort((String)WebPortUtil.getServerPort()));
        } else {
            System.setProperty("SERVICE_PORT", System.getProperty("dubbo.protocol.port", "20880"));
        }
        MSERVICE_DISCOVERY_TYPE = System.getProperty("mservice.discovery.type");
        if (StringUtils.isEmpty((String)MSERVICE_DISCOVERY_TYPE)) {
            MSERVICE_DISCOVERY_TYPE = config.get("mservice.discovery.type");
        }
    }

    private static Map<String, String> getConfig() {
        String assemblyType = ConfigurationUtil.getString((String)"mservice.assembly.type", (String)"lightboot_dubbo_zookeeper");
        Map<String, String> configMap = MserviceAssemblyConfig.getConfigFromMC(assemblyType);
        if (configMap == null || configMap.size() == 0) {
            configMap = MserviceAssemblyConfig.getConfigFromJar(assemblyType);
        }
        return configMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getConfigFromJar(String combineType) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        try (InputStream in = MserviceAssemblyConfig.class.getResourceAsStream("/kd/bos/mservice/config/" + combineType + ".config");){
            Properties prop = new Properties();
            prop.load(in);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Execute System.exit(1), Starting to exit the service", (Throwable)e);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.exit(-1);
            return map;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getConfigFromMC(String combineType) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        String value = System.getProperty(combineType + ".config");
        if (StringUtils.isEmpty((String)value)) {
            return map;
        }
        try (StringReader reader = new StringReader(value);){
            Properties prop = new Properties();
            prop.load(reader);
            for (String key : prop.stringPropertyNames()) {
                map.put(key, prop.getProperty(key));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
            return map;
        }
    }

    public static String getMserviceBooterType() {
        return MSERVICE_BOOTER_TYPE;
    }

    public static String getMserviceRpcType() {
        return MSERVICE_RPC_TYPE;
    }

    public static String getMserviceDiscoveryType() {
        return MSERVICE_DISCOVERY_TYPE;
    }

    static {
        MserviceAssemblyConfig.init();
    }
}

