/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.config;

import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class MserviceConfigUtil {
    public static String getRegisterUrlByType(String discovery) {
        String registerUrl = ConfigurationUtil.getString((String)"mservice.registry.url");
        if (StringUtils.isEmpty((String)registerUrl)) {
            return null;
        }
        String[] sl = registerUrl.split("\\?");
        String typeUrl = sl[0];
        String[] tu = typeUrl.split("@");
        String url = tu[1];
        int propIndex = registerUrl.indexOf(63);
        String userName = null;
        String password = null;
        if (propIndex > 0) {
            Properties prop = MserviceConfigUtil.parseUrl(sl[1]);
            userName = prop.getProperty("user");
            password = prop.getProperty("password");
        }
        StringBuilder sb = new StringBuilder();
        if ("eureka".equals(discovery)) {
            String[] urls;
            for (String l : urls = url.split(",")) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("http://");
                if (userName != null && password != null) {
                    buffer.append(userName).append(":").append(password).append("@");
                }
                buffer.append(l).append("/eureka/");
                sb.append(buffer);
            }
            return sb.toString();
        }
        if ("nacos".equals(discovery)) {
            if (userName != null && password != null) {
                if ("dubbo".equals(MserviceAssemblyConfig.MSERVICE_RPC_TYPE)) {
                    System.setProperty("nacos.registry.username", userName);
                    System.setProperty("nacos.registry.password", password);
                } else {
                    System.setProperty("spring.cloud.nacos.discovery.username", userName);
                    System.setProperty("spring.cloud.nacos.discovery.password", password);
                }
            }
            return url;
        }
        if ("zookeeper".equals(discovery)) {
            url = url.replaceFirst("http://", "");
            if (userName != null && password != null) {
                sb.append(url).append("?").append("user=").append(userName).append("&").append("password=").append(password);
                url = sb.toString();
            }
            return url;
        }
        return null;
    }

    private static Properties parseUrl(String urlParams) {
        Properties prop = new Properties();
        try {
            String[] params = null;
            params = urlParams.contains("&") ? urlParams.split("&") : new String[]{urlParams};
            String[] var8 = params;
            int var9 = params.length;
            for (int var10 = 0; var10 < var9; ++var10) {
                String p = var8[var10];
                if (p.startsWith("password")) {
                    String password = p.substring("password".length() + 1);
                    prop.put("password", password);
                    continue;
                }
                if (!p.contains("=")) continue;
                String[] param = p.split("=");
                if (param.length == 1) {
                    prop.put(param[0], "");
                    continue;
                }
                String key = param[0];
                String value = param[1];
                prop.put(key, value);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.configParseException, new Object[]{e.getMessage()});
        }
        return prop;
    }
}

