/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.service;

import java.util.HashSet;
import java.util.Iterator;
import kd.bos.config.client.Configuration;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.extension.ExtensionFactory;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.SysServiceLayerManager;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.spi.rpc.MServiceLookup;
import kd.bos.mservice.spi.rpc.MServiceRegister;
import kd.bos.mservice.spi.rpc.MServiceStarter;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.register.ServiceRegister;
import kd.bos.util.ConfigurationChangeListener;

public class MServiceStartService
implements Service {
    private static Log log = LogFactory.getLog(MServiceStartService.class);
    private static ExtensionFactory<MServiceLookup> lookupFactory = ExtensionFactory.getExtensionFacotry(MServiceLookup.class);
    private static ExtensionFactory<MServiceRegister> registerFactory = ExtensionFactory.getExtensionFacotry(MServiceRegister.class);
    private static ExtensionFactory<MServiceStarter> servicestarterFactory = ExtensionFactory.getExtensionFacotry(MServiceStarter.class);
    private boolean fIsStarted;
    private final String ext_service = ".service";
    private final String ext_consumer = ".consumer";

    public String getName() {
        return "MServiceStart";
    }

    public boolean isStarted() {
        return this.fIsStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        long start = System.currentTimeMillis();
        try {
            ServiceLookup.beginStartRpcService(start);
            MServiceStarter starter = (MServiceStarter)servicestarterFactory.getExtension(this.getServiceType());
            MServiceRegister register = (MServiceRegister)registerFactory.getExtension(this.getServiceType());
            if (register == null) {
                // empty if block
            }
            MServiceLookup loopup = (MServiceLookup)lookupFactory.getExtension(this.getServiceType());
            starter.start(start);
            ServiceLookup.setImpl(loopup);
            ServiceRegister.setImpl(register);
            this.registerDefault();
            starter.endStart();
            ServiceLookup.endStartRpcService();
        }
        catch (Error | Exception e) {
            log.error("RPC service start exception,Execute System.exit(-1), Starting to exit the service);", e);
            e.printStackTrace();
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.exit(-1);
        }
        finally {
            this.fIsStarted = true;
            long end = System.currentTimeMillis();
            log.info("MServiceStartService started, cost:" + (end - start) + "ms.");
        }
    }

    private void registerDefault() {
        if (!SysServiceLayerManager.isRegisterDefaultInterface()) {
            return;
        }
        String[] configNames = Instance.getConfigAppName();
        String configDubboAppService = System.getProperty("dubbo.service.configAppName", "");
        if (configDubboAppService.length() > 0) {
            configNames = configDubboAppService.split(",");
        }
        HashSet<String> hasRegister = new HashSet<String>();
        for (int i = 0; i < configNames.length; ++i) {
            String path = ConfigUtils.getAppServicePath((String)Instance.getClusterName(), (String)configNames[i]);
            Configuration configuration = ConfigurationFactory.getConfigurationByPath((String)path);
            configuration.addConfigurationChangeListener(new ConfigurationChangeListener(){

                public void onChange(Object key, Object value) {
                    MServiceStartService.mserviceConfigChanged(key, value);
                }
            });
            Iterator iter = configuration.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String text = configuration.getProperty(key);
                if (!hasRegister.add(key)) continue;
                if (key.endsWith(".consumer")) {
                    ServiceRegister.registerConsumer(key, text);
                    continue;
                }
                if (!key.endsWith(".service")) continue;
                ServiceRegister.registerService(key, text);
            }
        }
    }

    private static void mserviceConfigChanged(Object key, Object value) {
    }

    public void stop() {
    }

    private String getServiceType() {
        return MserviceAssemblyConfig.MSERVICE_RPC_TYPE;
    }
}

