/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.timeout;

import kd.bos.bundle.Resources;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.TerminationEvent;
import kd.bos.govern.timeout.TimeoutHandle;
import kd.bos.trace.util.TraceIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTimeoutHandle
implements TimeoutHandle {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimeoutHandle.class);
    private static final String PROJECT_NAME = "bos-mservice";

    public void start(RequestTimeoutContext requestTimeoutContext) {
    }

    public void handleTimeout() {
        this.handleManuallyTimeout();
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null && requestTimeoutContext.isAutomaticTimeout()) {
            if (requestTimeoutContext.isTimeoutExceptionThrown()) {
                return;
            }
            long costTime = System.currentTimeMillis() - requestTimeoutContext.getStartTime();
            long timeout = requestTimeoutContext.getTimeout();
            long remainder = timeout - costTime;
            if (remainder <= 0L) {
                String errorStr = Resources.get((String)PROJECT_NAME, (String)"RequestTimeoutGovern_1", (String)"\u8bf7\u6c42\u8d85\u65f6\u540e\u63d0\u793a\u5f02\u5e38\u4fe1\u606f", (Object[])new Object[]{requestTimeoutContext.getRequestOperation(), timeout / 1000L, costTime / 1000L, TraceIdUtil.idToHex((long)TraceIdUtil.createId())});
                Exception exception = new Exception();
                if (requestTimeoutContext.isWebRequest()) {
                    EventDataReporter.report((EventType)TerminationEvent.WebAutoTimeoutEvent.getInstance(), (String)errorStr, (Throwable)exception);
                } else {
                    EventDataReporter.report((EventType)TerminationEvent.ComponentTimeoutEvent.getInstance(), (String)errorStr, (Throwable)exception);
                }
                log.error(errorStr, (Throwable)exception);
                throw new KDException(BosErrorCode.govRequestTimeout, new Object[]{errorStr});
            }
        }
    }

    public void handleManuallyTimeout() {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null && requestTimeoutContext.isTimeoutByManually()) {
            long costTime = System.currentTimeMillis() - requestTimeoutContext.getStartTime();
            String msg = Resources.get((String)PROJECT_NAME, (String)"RequestTimeoutGovern_0", (String)"\u624b\u52a8\u7ec8\u6b62\u8bf7\u6c42\u540e\u63d0\u793a\u5f02\u5e38\u4fe1\u606f", (Object[])new Object[]{costTime / 1000L, TraceIdUtil.idToHex((long)TraceIdUtil.createId())});
            Exception exception = new Exception();
            if (requestTimeoutContext.isWebRequest()) {
                EventDataReporter.report((EventType)TerminationEvent.WebManualTimeoutEvent.getInstance(), (String)msg, (Throwable)exception);
            } else {
                log.error(msg, (Throwable)exception);
            }
            throw new KDException(BosErrorCode.govRequestTimeout, new Object[]{msg});
        }
    }

    public void doTimeoutMarker(boolean isMarker) {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null) {
            requestTimeoutContext.setTimeoutExceptionThrown(isMarker);
        }
    }

    public boolean getTimeoutMarker() {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null) {
            return requestTimeoutContext.isTimeoutExceptionThrown();
        }
        return false;
    }

    public int getRemainderTime() {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null && requestTimeoutContext.isAutomaticTimeout() && !requestTimeoutContext.isTimeoutExceptionThrown()) {
            long costTime = System.currentTimeMillis() - requestTimeoutContext.getStartTime();
            long timeout = requestTimeoutContext.getTimeout();
            long remainder = timeout - costTime;
            this.handleTimeout();
            if (remainder >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return remainder <= 1000L ? 1 : (int)remainder / 1000;
        }
        return Integer.MAX_VALUE;
    }

    public void close() {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        if (requestTimeoutContext != null) {
            requestTimeoutContext.clear();
        }
    }
}

