/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.timeout.filter;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.timeout.TimeoutHandle;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.mservice.util.ParsingUrlUtil;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class WebRequestTimeoutFilter
implements Filter {
    private static int webRequestTimeout;
    private static Set<String> webRequestCustomUriSet;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        int timeout = webRequestTimeout;
        if (!webRequestCustomUriSet.isEmpty()) {
            if (requestURI.contains("batchInvokeAction") || requestURI.contains("invokeAction")) {
                Map paramMap = httpRequest.getParameterMap();
                List<String> list = ParsingUrlUtil.parseBatchInvokeAction(requestURI, paramMap);
                requestURI = list.get(0);
            }
            if (webRequestCustomUriSet.contains(requestURI)) {
                timeout = Integer.getInteger("web.request.custom.timeout.time", 1800000);
            }
        }
        try (TimeoutHandle timeoutHandle = TimeoutHandleFactory.get();){
            timeoutHandle.start(new RequestTimeoutContext("WebRequest", httpRequest.getRequestURI(), (long)timeout).setAppId(httpRequest.getHeader("cqappid")));
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    private static Set<String> parseURIs(String uriString) {
        String[] uris;
        CopyOnWriteArraySet<String> uriSet = new CopyOnWriteArraySet<String>();
        if (StringUtils.isEmpty((String)uriString)) {
            return uriSet;
        }
        for (String uri : uris = uriString.split(",")) {
            uriSet.add(uri.trim());
        }
        return uriSet;
    }

    static {
        webRequestCustomUriSet = new CopyOnWriteArraySet<String>();
        try {
            webRequestTimeout = ConfigurationUtil.getInteger((String)"web.request.timeout.time", (Integer)300000);
            ConfigurationUtil.observeChange((String)"web.request.timeout.time", (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    webRequestTimeout = Integer.getInteger("web.request.timeout.time", 300000);
                }
            });
            ConfigurationUtil.observeChange((String)"web.request.custom.timeout.uri", (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    webRequestCustomUriSet = WebRequestTimeoutFilter.parseURIs(System.getProperty("web.request.custom.timeout.uri"));
                }
            });
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.govRequestTimeout, "WebRequestTimeoutFilter get webRequestTimeout config error ", (Throwable)e);
        }
    }
}

