/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.StringUtils;

public class JSONUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toString(Object source) throws IOException {
        return JSONUtils.toString(source, false);
    }

    public static String toString(Object source, boolean indent) throws IOException {
        try {
            String result;
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
                mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            }
            String string = result = mapper.writeValueAsString(source);
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (indent) {
                mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
            }
        }
    }

    public static <T> T cast(String source, Class<T> type) throws IOException {
        return JSONUtils.cast(source, type, false);
    }

    public static <T> T cast(String source, Class<T> type, boolean ignoreUnkownField) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static <T> T cast(String source, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        return JSONUtils.cast(source, true, collectionType, elementType);
    }

    public static <T> T cast(String source, boolean ignoreUnkownField, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        try {
            Object result;
            if (ignoreUnkownField) {
                mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
            JavaType type = JSONUtils.getCollectionType(collectionType, elementType);
            Object object = result = mapper.readValue(source, type);
            return (T)object;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (ignoreUnkownField) {
                mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            }
        }
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String getEmpty() {
        return "{}";
    }

    public static String nullDataToEmptyList(String sHttpResponse) throws Exception {
        if (StringUtils.isBlank((String)sHttpResponse)) {
            return sHttpResponse;
        }
        Map resMap = JSONUtils.cast(sHttpResponse, HashMap.class, true);
        if (resMap != null && StringUtils.isBlank((String)((String)resMap.get("data")))) {
            resMap.put("data", new ArrayList());
            return JSONUtils.toString(resMap);
        }
        return sHttpResponse;
    }

    static {
        mapper.writer().withFeatures(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS});
    }
}

