/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.lookup;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.config.client.RuntimeGlobalProperties;
import kd.bos.context.RequestContext;
import kd.bos.instance.Cluster;
import kd.bos.mservice.spi.rpc.MServiceLookup;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.StringUtils;

public final class ServiceLookup {
    private static MServiceLookup impl;
    private static long startTimesnap;
    private static boolean isRpcServiceStarting;
    private static Map<String, Set<String>> clusterAppIds;
    private static Set<String> systemAppIds;

    public static void setImpl(MServiceLookup lookup) {
        impl = lookup;
    }

    public static void endStartRpcService() {
        isRpcServiceStarting = false;
    }

    public static void beginStartRpcService(long timesnap) {
        startTimesnap = timesnap;
        isRpcServiceStarting = true;
    }

    public static <T> T lookup(String id) {
        throw new UnsupportedOperationException("Not supported. use lookup(class,appId) instead.");
    }

    public static <T> T lookup(Class<T> clazz) {
        return ServiceLookup.lookup(clazz, "bos");
    }

    public static <T> T lookup(Class<T> clazz, String appId) {
        if (impl == null) {
            if (isRpcServiceStarting) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                throw new Error("RpcService service is starting , start at: " + sdf.format(new Date(startTimesnap)));
            }
            throw new Error("ServiceLookup not implemented .");
        }
        Object t = impl.lookup(clazz, appId);
        if (t == null) {
            throw new RuntimeException("Mservice consumer by class '" + clazz + "' and appId '" + appId + "' not found.");
        }
        return (T)t;
    }

    public static <T> T lookupHttp(Class<T> clazz, String appId, String dataCodecType) {
        if (impl == null) {
            if (isRpcServiceStarting) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                throw new Error("RpcService service is starting , start at: " + sdf.format(new Date(startTimesnap)));
            }
            throw new Error("ServiceLookup not implemented .");
        }
        Object t = impl.lookupHttp(clazz, appId, dataCodecType);
        if (t == null) {
            throw new RuntimeException("Mservice consumer by class '" + clazz + "' and appId '" + appId + "' not found.");
        }
        return (T)t;
    }

    public static <T> T lookupEndpoint(Class<T> clazz, String ip, String port) {
        if (impl == null) {
            if (isRpcServiceStarting) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                throw new Error("RpcService service is starting , start at: " + sdf.format(new Date(startTimesnap)));
            }
            throw new Error("lookupEndpoint not implemented .");
        }
        if (StringUtils.isEmpty((String)ip)) {
            throw new RuntimeException("lookupEndpoint ip can not be empty");
        }
        Object t = impl.lookupEndpoint(clazz, ip, port);
        if (t == null) {
            throw new RuntimeException("Mservice consumer by class '" + clazz + "' and ip '" + ip + "' not found.");
        }
        return (T)t;
    }

    public static void addSystemAppId(String ... appIds) {
        for (String id : appIds) {
            systemAppIds.add(id);
        }
    }

    public static Set<String> getSystemAppIds() {
        return Collections.unmodifiableSet(systemAppIds);
    }

    public static String getServiceAppId(String appId) {
        String[] leafAppIds = appId.split("\\.");
        for (int i = leafAppIds.length - 1; i >= 0; --i) {
            String leafAppId = ServiceLookup._getServiceAppId(leafAppIds[i]);
            if (leafAppId == null) continue;
            return leafAppId;
        }
        ThreadTruck.put((Object)"customForLastestAppid", (Object)appId);
        String customAppid = ServiceLookup._getServiceAppId("custom");
        return customAppid == null ? appId : "custom";
    }

    public static boolean hasDeployedAppId(String appId) {
        String strAppIds = System.getProperty("registedAppIds");
        if (strAppIds != null) {
            String cloudtag;
            boolean b;
            Set<String> appIds = clusterAppIds.get(strAppIds);
            if (appIds == null) {
                String[] arrayAppids = strAppIds.split(",");
                appIds = new HashSet<String>(arrayAppids.length);
                for (String id : arrayAppids) {
                    appIds.add(id);
                }
                clusterAppIds.put(strAppIds, appIds);
            }
            if (b = appIds.contains(appId)) {
                return true;
            }
            RequestContext rc = RequestContext.get();
            String deployCloud = Cluster.getCloudByApp((String)appId, (String)(rc == null ? null : rc.getAccountId()));
            if (deployCloud != null && appIds.contains(cloudtag = "cloud--" + deployCloud)) {
                return true;
            }
        }
        return false;
    }

    private static String _getServiceAppId(String appId) {
        String[] arrayAppids;
        Set<String> appIds;
        String strAppIds = System.getProperty("registedAppIds");
        if (strAppIds != null) {
            String cloudtag;
            appIds = clusterAppIds.get(strAppIds);
            if (appIds == null) {
                arrayAppids = strAppIds.split(",");
                appIds = new HashSet<String>(arrayAppids.length);
                for (String id : arrayAppids) {
                    appIds.add(id);
                }
                clusterAppIds.put(strAppIds, appIds);
            }
            if (appIds.contains(appId)) {
                return appId;
            }
            RequestContext rc = RequestContext.get();
            String deployCloud = Cluster.getCloudByApp((String)appId, (String)(rc == null ? null : rc.getAccountId()));
            if (deployCloud != null && appIds.contains(cloudtag = "cloud--" + deployCloud)) {
                return cloudtag;
            }
        }
        if (systemAppIds.contains(appId)) {
            return appId;
        }
        if (Boolean.getBoolean("customAppIds.lookup")) {
            strAppIds = System.getProperty("customAppIds");
            if (strAppIds == null) {
                strAppIds = RuntimeGlobalProperties.get((String)"customAppIds");
            }
            if (strAppIds != null) {
                appIds = clusterAppIds.get(strAppIds);
                if (appIds == null) {
                    arrayAppids = strAppIds.split(",");
                    appIds = new HashSet<String>(arrayAppids.length);
                    for (String id : arrayAppids) {
                        appIds.add(id);
                    }
                    clusterAppIds.put(strAppIds, appIds);
                }
                if (appIds.contains(appId)) {
                    return appId;
                }
            }
        }
        return null;
    }

    static {
        startTimesnap = -1L;
        isRpcServiceStarting = false;
        clusterAppIds = new ConcurrentHashMap<String, Set<String>>(1);
        systemAppIds = new HashSet<String>();
    }
}

