/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register;

import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.common.codec.TypeDefines;
import kd.bos.mservice.discovery.KRegistryInstanceCatalog;
import kd.bos.mservice.spi.rpc.MServiceRegister;
import kd.bos.util.WebPortUtil;

public final class ServiceRegister {
    private static MServiceRegister impl;
    private static Log log;

    public static void setImpl(MServiceRegister impl) {
        if (impl == null) {
            return;
        }
        ServiceRegister.impl = impl;
    }

    public static void registerConsumer(String name, String config) {
        String transProtocolType = TypeDefines.TransProtocolTypes.getTransProtocolType((String)config);
        if ("http".equals(transProtocolType) && !impl.supportHttp()) {
            log.warn(String.format("not register consumer for %s:%s, %s not support Http TransProtocolTypes ", name, config, impl.getClass().getName()));
            return;
        }
        impl.registerConsumer(name, config);
    }

    public static void registerService(String name, String config) {
        String transProtocolType = TypeDefines.TransProtocolTypes.getTransProtocolType((String)config);
        if ("http".equals(transProtocolType) && !impl.supportHttp()) {
            log.warn(String.format("not register service for %s:%s, %s not support Http TransProtocolTypes ", name, config, impl.getClass().getName()));
            return;
        }
        KRegistryInstanceCatalog.registerService(name, config, transProtocolType);
        impl.registerService(name, config);
    }

    public static boolean isMServiceRegistryEnable() {
        if (WebPortUtil.isWebNode() && !Instance.isWebMserviceInOne()) {
            return false;
        }
        return !"false".equals(System.getProperty("mservice.registry.register", "true"));
    }

    static {
        log = LogFactory.getLog(ServiceRegister.class);
    }
}

