/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.register.extra.AbstractExtraAutoServiceRegistration;
import kd.bos.service.register.extra.spi.ExtraAutoServiceRegistration;
import kd.bos.threads.ThreadPools;
import kd.bos.util.AppUtils;

public class ExtraRegisterStartService {
    private static final Log log = LogFactory.getLog(ExtraRegisterStartService.class);
    private static final Set<String> appIdSet = new HashSet<String>(2);

    public static void start(String interfaceName, String config) {
        if (!Boolean.getBoolean("mservice.extra.registry.enable")) {
            log.info("ExtraRegisterStartService Lifecycle disabled. Not starting");
            return;
        }
        Map<String, Set<String>> interfaceAppIds = ExtraRegisterStartService.parseConfig(interfaceName, config);
        ServiceLoader<ExtraAutoServiceRegistration> serviceLoader = ServiceLoader.load(ExtraAutoServiceRegistration.class);
        Iterator<ExtraAutoServiceRegistration> itr = serviceLoader.iterator();
        while (itr.hasNext()) {
            try {
                ExtraAutoServiceRegistration autoServiceRegistration = itr.next();
                if (!(autoServiceRegistration instanceof AbstractExtraAutoServiceRegistration)) continue;
                log.info("ExtraRegisterStartService serviceLoader successfully loaded class: " + autoServiceRegistration.getClass().getName());
                if (Boolean.getBoolean("mservice.extra.registry.syn.enable")) {
                    ((AbstractExtraAutoServiceRegistration)autoServiceRegistration).start(interfaceAppIds);
                    continue;
                }
                ThreadPools.executeOnce((String)"MultiRegistryThread", () -> {
                    try {
                        ((AbstractExtraAutoServiceRegistration)autoServiceRegistration).start(interfaceAppIds);
                    }
                    catch (Exception e) {
                        log.warn("AbstractExtraAutoServiceRegistration  start failed,errorMessage:" + e.getMessage(), (Throwable)e);
                    }
                });
            }
            catch (Error | Exception e) {
                log.warn("Load ExtraAutoServiceRegistration failed,errorMessage:" + e.getMessage(), e);
            }
        }
    }

    private static Map<String, Set<String>> parseConfig(String name, String config) {
        HashMap<String, Set<String>> intefaceAppIds = new HashMap<String, Set<String>>(4);
        Properties p = new Properties();
        try {
            p.load(new StringReader(config));
            String i = (String)p.get("interface");
            intefaceAppIds.put(i, ExtraRegisterStartService.getAppIds(p));
            return intefaceAppIds;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"ExtraRegisterStartService registerService error:" + name});
        }
    }

    private static Set<String> getAppIds(Properties props) {
        String str = props.getProperty("appIds");
        if (str == null) {
            return appIdSet;
        }
        HashSet<String> appidSet = new HashSet<String>(2);
        if (Instance.isAppSplit()) {
            for (String appId : Instance.parseAppIds((String)str)) {
                appidSet.add(appId);
            }
        }
        return appidSet;
    }

    static {
        String[] appIds = Instance.getAppIds();
        boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])appIds);
        if (Instance.isAppSplit() && appIds != null || isCurrentDeployAlone) {
            for (String appId : appIds) {
                if (Instance.getDeployedCloudByApp((String)appId) != null) continue;
                appIdSet.add(appId);
            }
            Set clouds = Instance.getDeployedClouds();
            clouds.forEach(cloud -> {
                String cloudtag = "cloud--" + cloud;
                appIdSet.add(cloudtag);
            });
        }
    }
}

