/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Objects;
import java.util.Properties;

public class NacosExtraServiceManager {
    private NamingService namingService;
    private NamingMaintainService namingMaintainService;

    public NamingService getNamingService(Properties properties) {
        if (Objects.isNull(this.namingService)) {
            this.buildNamingService(properties);
        }
        return this.namingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingService buildNamingService(Properties properties) {
        if (!Objects.isNull(this.namingService)) return this.namingService;
        Class<NacosExtraServiceManager> clazz = NacosExtraServiceManager.class;
        synchronized (NacosExtraServiceManager.class) {
            if (!Objects.isNull(this.namingService)) return this.namingService;
            this.namingService = this.createNewNamingService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingService;
        }
    }

    private NamingService createNewNamingService(Properties properties) {
        try {
            return NacosFactory.createNamingService((Properties)properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NamingMaintainService getNamingMaintainService(Properties properties) {
        if (Objects.isNull(this.namingMaintainService)) {
            this.buildNamingMaintainService(properties);
        }
        return this.namingMaintainService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingMaintainService buildNamingMaintainService(Properties properties) {
        if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
        Class<NacosExtraServiceManager> clazz = NacosExtraServiceManager.class;
        synchronized (NacosExtraServiceManager.class) {
            if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
            this.namingMaintainService = this.createNamingMaintainService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingMaintainService;
        }
    }

    private NamingMaintainService createNamingMaintainService(Properties properties) {
        try {
            return NacosFactory.createMaintainService((Properties)properties);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }

    public void nacosServiceShutDown() throws NacosException {
        this.namingService.shutDown();
        this.namingService = null;
        this.namingMaintainService = null;
    }
}

