/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.register.extra.nacos;

import java.net.URI;
import java.util.Map;
import kd.bos.service.register.extra.ServiceRegistration;
import kd.bos.service.register.extra.nacos.NacosExtraProperties;

public class NacosServiceRegistration
implements ServiceRegistration {
    private final NacosExtraProperties nacosExtraProperties;

    public NacosServiceRegistration(NacosExtraProperties nacosExtraProperties) {
        this.nacosExtraProperties = nacosExtraProperties;
    }

    public NacosExtraProperties getNacosMultiProperties() {
        return this.nacosExtraProperties;
    }

    @Override
    public String getInstanceId() {
        return ServiceRegistration.super.getInstanceId();
    }

    @Override
    public String getServiceId() {
        return this.nacosExtraProperties.getAppName();
    }

    @Override
    public String getHost() {
        return this.nacosExtraProperties.getIp();
    }

    @Override
    public int getPort() {
        return this.nacosExtraProperties.getPort();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public URI getUri() {
        String scheme = this.isSecure() ? "https" : "http";
        String uri = String.format("%s://%s:%s", scheme, this.getHost(), this.getPort());
        return URI.create(uri);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.nacosExtraProperties.getMetadata();
    }

    @Override
    public String getScheme() {
        return ServiceRegistration.super.getScheme();
    }

    public void setPort(int port) {
        this.nacosExtraProperties.setPort(port);
    }
}

