/*
 * Decompiled with CFR 0.152.
 */
package kd.bos;

import java.util.concurrent.locks.LockSupport;
import kd.bos.fake.zookeeper.EmbedZookeeperService;
import kd.bos.service.webserver.JettyServer;
import kd.bos.threads.ThreadPools;
import kd.bos.util.DisCardUtil;
import kd.bos.util.SystemProperties;
import kd.bos.util.WebPortUtil;

public class BosLightWeightDeployInit {
    public BosLightWeightDeployInit() {
        this.setPropertyIfEmpty("appSplit", "false");
        this.setPropertyIfEmpty("appName", "LightWeightDeploy");
        WebPortUtil.setWebPortIfEmpty((String)"8080");
        System.setProperty("configAppName", "mservice,web");
        System.setProperty("webmserviceinone", "true");
        System.setProperty("lightweightdeploy", "true");
        this.setPropertyIfEmpty("MONITOR_HTTP_PORT", "9998");
        this.setPropertyIfEmpty("JMX_HTTP_PORT", "9091");
        this.setPropertyIfEmpty("JETTY_WEBAPP_PATH", "C:/bos-evn-dev/mservice/webapp");
        this.setPropertyIfEmpty("JETTY_WEBRES_PATH", "C:/bos-evn-dev/static-file-service/webapp");
        this.setPropertyIfEmpty("ActionConfigFile", "C:/bos-evn-dev/mservice/conf/actionconfig.xml");
        System.setProperty("configUrl", "localhost:" + System.getProperty("embed.zookeeper.port", "12192"));
        System.setProperty("clusterName", "bos-embed");
        ThreadPools.executeOnce((String)"embedzookeeperMain", () -> {
            try {
                EmbedZookeeperService.main(null);
            }
            catch (Exception e) {
                System.exit(1);
            }
        });
        LockSupport.parkNanos(1000000000L);
        try {
            Class.forName("kd.bos.config.client.ConfigurationFactory");
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    public void start() {
        String[] args = null;
        try {
            JettyServer.main(args);
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }

    protected final void setPropertyIfEmpty(String key, String value) {
        if (SystemProperties.getWithEnv((String)key) == null) {
            System.setProperty(key, value);
        }
    }

    public static void main(String[] args) {
        new BosLightWeightDeployInit().start();
    }
}

