/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fake.redis.ehcache;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.ehcache.EhcacheFactory;
import kd.bos.exception.KDException;
import kd.bos.fake.FakeErrorCode;
import kd.bos.fake.redis.JedisFake;
import kd.bos.fake.redis.ehcache.ByteWrap;
import kd.bos.fake.redis.ehcache.JedisFakeEhcacheTimeExpirer;
import kd.bos.util.DisCardUtil;
import kd.bos.util.resource.Resources;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.util.SafeEncoder;

public class JedisFakeEhcache
implements JedisFake {
    private Cache<ByteWrap, Object> cache;
    private Map<ByteWrap, Long> expireKeyMap;
    private String region;
    private static final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private static final int DEFAULT_TIMEOUT = 3600;

    public JedisFakeEhcache(String region) {
        this.region = region;
        this.cache = this.newCache(this.region, 36000, 0, 0);
        this.expireKeyMap = new ConcurrentHashMap<ByteWrap, Long>();
        JedisFakeEhcacheTimeExpirer.registerEntry(this.cache, this.expireKeyMap);
    }

    @Override
    public Long del(String key) {
        return this.del(SafeEncoder.encode((String)key));
    }

    @Override
    public Boolean exists(String key) {
        return this.exists(SafeEncoder.encode((String)key));
    }

    @Override
    public Long expire(String key, int second) {
        return this.expire(SafeEncoder.encode((String)key), second);
    }

    @Override
    public Long expire(String key, long second) {
        return this.expire(SafeEncoder.encode((String)key), second);
    }

    @Override
    public String get(String key) {
        byte[] bytes = this.get(SafeEncoder.encode((String)key));
        if (bytes == null) {
            return null;
        }
        return SafeEncoder.encode((byte[])bytes);
    }

    @Override
    public String set(String key, String value) {
        return this.setex(key, this.getDefaultTimeout(), value);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        ByteWrap keyWrap = new ByteWrap(key);
        Object o = this.cache.get((Object)keyWrap);
        if (o == null || o instanceof ByteWrap) {
            this.cache.put((Object)keyWrap, (Object)new ByteWrap(value));
            return "OK";
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"String"});
    }

    @Override
    public String setex(String key, int timeoutSeconds, String value) {
        return this.setex(SafeEncoder.encode((String)key), timeoutSeconds, SafeEncoder.encode((String)value));
    }

    @Override
    public String setex(String key, long timeoutSeconds, String value) {
        return this.setex(SafeEncoder.encode((String)key), timeoutSeconds, SafeEncoder.encode((String)value));
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        ByteWrap keyWrap = new ByteWrap(key);
        Object o = this.cache.get((Object)keyWrap);
        if (o == null || o instanceof ByteWrap) {
            this.cache.put((Object)keyWrap, (Object)new ByteWrap(value));
            this.expire(key, seconds);
            return "OK";
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"String"});
    }

    @Override
    public String setex(byte[] key, long seconds, byte[] value) {
        ByteWrap keyWrap = new ByteWrap(key);
        Object o = this.cache.get((Object)keyWrap);
        if (o == null || o instanceof ByteWrap) {
            this.cache.put((Object)keyWrap, (Object)new ByteWrap(value));
            this.expire(key, seconds);
            return "OK";
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"String"});
    }

    @Override
    public Long hdel(String key, String ... keys) {
        return this.hdel(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(byte[] key, byte[] ... field) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return 0L;
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                long count = 0L;
                for (byte[] hkey : field) {
                    if (m.remove(new ByteWrap(hkey)) == null) continue;
                    ++count;
                }
                return count;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public Boolean hexists(String key, String hkey) {
        return this.hexists(SafeEncoder.encode((String)key), SafeEncoder.encode((String)hkey));
    }

    @Override
    public Boolean hexists(byte[] key, byte[] hkey) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return false;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            return m.containsKey(new ByteWrap(hkey));
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public String hget(String key, String hkey) {
        byte[] bytes = this.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)hkey));
        if (bytes != null) {
            return SafeEncoder.encode((byte[])bytes);
        }
        return null;
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        Map<byte[], byte[]> bMap = this.hgetAll(SafeEncoder.encode((String)key));
        if (bMap == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> sMap = new HashMap<String, String>(bMap.size());
        for (Map.Entry<byte[], byte[]> entry : bMap.entrySet()) {
            sMap.put(SafeEncoder.encode((byte[])entry.getKey()), SafeEncoder.encode((byte[])entry.getValue()));
        }
        return sMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return new HashMap<byte[], byte[]>(0);
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                HashMap<byte[], byte[]> _m = new HashMap<byte[], byte[]>(8);
                for (Map.Entry entry : m.entrySet()) {
                    _m.put(((ByteWrap)entry.getKey()).getBytes(), ((ByteWrap)entry.getValue()).getBytes());
                }
                return _m;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map<byte[], byte[]>"});
    }

    @Override
    public Set<String> hkeys(String key) {
        Set<byte[]> bSet = this.hkeys(SafeEncoder.encode((String)key));
        if (bSet == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> sSet = new HashSet<String>(bSet.size());
        bSet.forEach(k -> sSet.add(SafeEncoder.encode((byte[])k)));
        return sSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return new HashSet<byte[]>(0);
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                TreeSet<byte[]> set = new TreeSet<byte[]>(new ByteComparator());
                m.keySet().forEach(k -> set.add(k.getBytes()));
                return set;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public Long hlen(String key) {
        return this.hlen(SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return 0L;
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                return m.size();
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public List<String> hmget(String key, String[] keys) {
        List<byte[]> bList = this.hmget(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])keys));
        ArrayList<String> sList = new ArrayList<String>(bList.size());
        for (byte[] bytes : bList) {
            if (bytes != null) {
                sList.add(SafeEncoder.encode((byte[])bytes));
                continue;
            }
            sList.add(null);
        }
        return sList;
    }

    @Override
    public String hmset(String key, Map<String, String> keyValues) {
        TreeMap<byte[], byte[]> bKeyValues = new TreeMap<byte[], byte[]>(new ByteComparator());
        keyValues.forEach((k, v) -> bKeyValues.put(SafeEncoder.encode((String)k), SafeEncoder.encode((String)v)));
        return this.hmset(SafeEncoder.encode((String)key), bKeyValues);
    }

    @Override
    public Long hset(String key, String hkey, String value) {
        return this.hset(SafeEncoder.encode((String)key), SafeEncoder.encode((String)hkey), SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _field = new ByteWrap(field);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new ConcurrentHashMap());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                ByteWrap oldValue = m.put(_field, new ByteWrap(value));
                if (oldValue == null) {
                    return 1L;
                }
                return 0L;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map_Byte[]"});
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.hincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _field = new ByteWrap(field);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new ConcurrentHashMap());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof Map) {
            try {
                Map m;
                Map map = m = (Map)o;
                synchronized (map) {
                    ByteWrap fVal = (ByteWrap)m.get(_field);
                    long val = fVal == null ? value : Long.parseLong(SafeEncoder.encode((byte[])fVal.getBytes())) + value;
                    ByteWrap newVal = new ByteWrap(SafeEncoder.encode((String)String.valueOf(val)));
                    m.put(_field, newVal);
                    return val;
                }
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6574\u6570", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public Double hincrbyfloat(String key, String field, double value) {
        return this.hincrbyfloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double hincrbyfloat(byte[] key, byte[] field, double value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _field = new ByteWrap(field);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new ConcurrentHashMap());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof Map) {
            try {
                Map m;
                Map map = m = (Map)o;
                synchronized (map) {
                    ByteWrap fVal = (ByteWrap)m.get(_field);
                    double val = fVal == null ? value : Double.parseDouble(SafeEncoder.encode((byte[])fVal.getBytes())) + value;
                    ByteWrap newVal = new ByteWrap(SafeEncoder.encode((String)String.valueOf(val)));
                    m.put(_field, newVal);
                    return val;
                }
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6570\u503c", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        return this.hsetnx(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _field = new ByteWrap(field);
        if (!this.cache.containsKey((Object)_key)) {
            this.cache.put((Object)_key, new HashMap(6));
        }
        if ((o = this.cache.get((Object)_key)) instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                if (!m.containsKey(_field)) {
                    m.put(_field, new ByteWrap(value));
                    return 1L;
                }
                return 0L;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public List<String> hvals(String key) {
        List<byte[]> bList = this.hvals(SafeEncoder.encode((String)key));
        ArrayList<String> sList = new ArrayList<String>(bList.size());
        bList.forEach(bytes -> sList.add(SafeEncoder.encode((byte[])bytes)));
        return sList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> hvals(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return new ArrayList<byte[]>();
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                ArrayList<byte[]> ls = new ArrayList<byte[]>(8);
                for (Map.Entry entry : m.entrySet()) {
                    ls.add(((ByteWrap)entry.getValue()).getBytes());
                }
                return ls;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public synchronized Long incr(String key) {
        return this.incr(SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long incr(byte[] key) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, (Object)new ByteWrap(SafeEncoder.encode((String)"1")));
                    return 1L;
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof ByteWrap) {
            ByteWrap byteWrap = (ByteWrap)o;
            long newVal = 0L;
            try {
                String oldVal = SafeEncoder.encode((byte[])byteWrap.getBytes());
                newVal = Long.parseLong(oldVal) + 1L;
                String newStr = String.valueOf(newVal);
                o = new ByteWrap(SafeEncoder.encode((String)newStr));
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6574\u6570", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
            this.cache.put((Object)_key, o);
            return newVal;
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"int or long"});
    }

    @Override
    public synchronized Long incrBy(String key, long value) {
        return this.incrBy(SafeEncoder.encode((String)key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long incrBy(byte[] key, long value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, (Object)new ByteWrap(SafeEncoder.encode((String)String.valueOf(value))));
                    return value;
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof ByteWrap) {
            ByteWrap byteWrap = (ByteWrap)o;
            long newVal = 0L;
            try {
                String oldVal = SafeEncoder.encode((byte[])byteWrap.getBytes());
                newVal = Long.parseLong(oldVal) + value;
                String newStr = String.valueOf(newVal);
                o = new ByteWrap(SafeEncoder.encode((String)newStr));
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6574\u6570", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
            this.cache.put((Object)_key, o);
            return newVal;
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"int or long"});
    }

    @Override
    public Long decr(String key) {
        return this.decr(SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long decr(byte[] key) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, (Object)new ByteWrap(SafeEncoder.encode((String)"-1")));
                    return -1L;
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof ByteWrap) {
            ByteWrap byteWrap = (ByteWrap)o;
            long newVal = 0L;
            try {
                String oldVal = SafeEncoder.encode((byte[])byteWrap.getBytes());
                newVal = Long.parseLong(oldVal) - 1L;
                String newStr = String.valueOf(newVal);
                o = new ByteWrap(SafeEncoder.encode((String)newStr));
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6574\u6570", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
            this.cache.put((Object)_key, o);
            return newVal;
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"int or long"});
    }

    @Override
    public synchronized Long decrBy(String key, long value) {
        return this.decrBy(SafeEncoder.encode((String)key), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Long decrBy(byte[] key, long value) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, (Object)new ByteWrap(SafeEncoder.encode((String)String.valueOf(value))));
                    return value;
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof ByteWrap) {
            ByteWrap byteWrap = (ByteWrap)o;
            long newVal = 0L;
            try {
                String oldVal = SafeEncoder.encode((byte[])byteWrap.getBytes());
                newVal = Long.parseLong(oldVal) - value;
                String newStr = String.valueOf(newVal);
                o = new ByteWrap(SafeEncoder.encode((String)newStr));
            }
            catch (NumberFormatException e) {
                throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{o + " " + Resources.getString((String)"\u4e0d\u662f\u6574\u6570", (String)"FakeErrorCode_0", (String)"bos-fake", (Object[])new Object[0])});
            }
            this.cache.put((Object)_key, o);
            return newVal;
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"int or long"});
    }

    @Override
    public String lindex(String key, long index) {
        byte[] bytes = this.lindex(SafeEncoder.encode((String)key), index);
        if (bytes == null) {
            return null;
        }
        return SafeEncoder.encode((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lindex(byte[] key, long index) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int lsize = l.size();
                if (index < 0L) {
                    index = (long)lsize + index;
                }
                if ((long)lsize < index || index < 0L) {
                    return null;
                }
                ByteWrap v = (ByteWrap)l.get((int)index);
                return v.getBytes();
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION position, String pivot, String value) {
        return this.linsert(SafeEncoder.encode((String)key), position, SafeEncoder.encode((String)pivot), SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION position, byte[] pivot, byte[] value) {
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _pivot = new ByteWrap(pivot);
        ByteWrap _value = new ByteWrap(value);
        Object o = this.cache.get((Object)_key);
        if (o == null) {
            return 0L;
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int pivotindex = -1;
                int lsize = l.size();
                if (lsize == 0) {
                    return -1L;
                }
                for (int i = 0; i < lsize; ++i) {
                    ByteWrap lv = (ByteWrap)l.get(i);
                    if (pivot == null) {
                        if (lv != null) continue;
                        pivotindex = i;
                        break;
                    }
                    if (!_pivot.equals(lv)) continue;
                    pivotindex = i;
                    break;
                }
                if (pivotindex >= 0) {
                    if (BinaryClient.LIST_POSITION.BEFORE == position) {
                        l.add(pivotindex, _value);
                    } else {
                        l.add(pivotindex + 1, _value);
                    }
                    return l.size();
                }
                return -1L;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long linsert(String key, ListPosition position, String pivot, String value) {
        return this.linsert(SafeEncoder.encode((String)key), position, SafeEncoder.encode((String)pivot), SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long linsert(byte[] key, ListPosition position, byte[] pivot, byte[] value) {
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _pivot = new ByteWrap(pivot);
        ByteWrap _value = new ByteWrap(value);
        Object o = this.cache.get((Object)_key);
        if (o == null) {
            return 0L;
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int pivotindex = -1;
                int lsize = l.size();
                if (lsize == 0) {
                    return -1L;
                }
                for (int i = 0; i < lsize; ++i) {
                    ByteWrap lv = (ByteWrap)l.get(i);
                    if (pivot == null) {
                        if (lv != null) continue;
                        pivotindex = i;
                        break;
                    }
                    if (!_pivot.equals(lv)) continue;
                    pivotindex = i;
                    break;
                }
                if (pivotindex >= 0) {
                    if (ListPosition.BEFORE == position) {
                        l.add(pivotindex, _value);
                    } else {
                        l.add(pivotindex + 1, _value);
                    }
                    return l.size();
                }
                return -1L;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long llen(String key) {
        return this.llen(SafeEncoder.encode((String)key));
    }

    @Override
    public Long llen(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return 0L;
        }
        if (o instanceof List) {
            List l = (List)o;
            return l.size();
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public List<String> lrange(String key, long start, long stop) {
        List<byte[]> bytes = this.lrange(SafeEncoder.encode((String)key), start, stop);
        ArrayList<String> sList = new ArrayList<String>(bytes.size());
        bytes.forEach(b -> sList.add(SafeEncoder.encode((byte[])b)));
        return sList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> lrange(byte[] key, long start, long stop) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null || start > stop) {
            return new ArrayList<byte[]>(0);
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int _stop = (int)stop + 1;
                int lszie = l.size();
                if (start >= (long)lszie) {
                    return new ArrayList<byte[]>(0);
                }
                if (_stop > lszie) {
                    _stop = lszie;
                }
                List sub = l.subList((int)start, _stop);
                ArrayList<byte[]> bytes = new ArrayList<byte[]>(sub.size());
                sub.forEach(b -> bytes.add(b.getBytes()));
                return bytes;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long lrem(String key, long count, String payload) {
        return this.lrem(SafeEncoder.encode((String)key), count, SafeEncoder.encode((String)payload));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(byte[] key, long count, byte[] payload) {
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _payload = new ByteWrap(payload);
        Object o = this.cache.get((Object)_key);
        if (o == null || payload == null) {
            return 0L;
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int remcount = 0;
                if (count == 0L) {
                    for (int i = l.size() - 1; i >= 0; --i) {
                        if (!_payload.equals(l.get(i))) continue;
                        l.remove(i);
                        ++remcount;
                    }
                } else if (count < 0L) {
                    count = -1L * count;
                    for (int i = l.size() - 1; i >= 0; --i) {
                        if (!_payload.equals(l.get(i))) continue;
                        l.remove(i);
                        if ((long)(++remcount) != count) {
                            continue;
                        }
                        break;
                    }
                } else {
                    int lszie = l.size();
                    for (int i = 0; i < lszie; ++i) {
                        if (!_payload.equals(l.get(i))) continue;
                        l.remove(i--);
                        --lszie;
                        if ((long)(++remcount) != count) {
                            continue;
                        }
                        break;
                    }
                }
                return remcount;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public String lset(String key, long index, String value) {
        return this.lset(SafeEncoder.encode((String)key), index, SafeEncoder.encode((String)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(byte[] key, long index, byte[] value) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            throw new KDException(FakeErrorCode.redisIndexOutOfArray, new Object[]{" list " + Resources.getString((String)"\u4e0d\u5b58\u5728: ", (String)"JedisFakeEhcache_1", (String)"bos-fake", (Object[])new Object[0]) + key});
        }
        if (o instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                int lsize = l.size();
                if (index < 0L) {
                    index = (long)lsize + index;
                }
                if (index < 0L || index >= (long)lsize) {
                    throw new KDException(FakeErrorCode.redisIndexOutOfArray, new Object[]{"index:" + index + ",list size:" + l.size()});
                }
                l.set((int)index, new ByteWrap(value));
            }
            return "ok";
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long rpush(String key, String[] values) {
        return this.rpush(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(byte[] key, byte[] ... values) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new ArrayList());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof List) {
            List l;
            List list = l = (List)o;
            synchronized (list) {
                for (byte[] v : values) {
                    l.add(new ByteWrap(v));
                }
                return l.size();
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"List"});
    }

    @Override
    public Long sadd(String key, String[] values) {
        return this.sadd(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(byte[] key, byte[] ... values) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new HashSet());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof Set) {
            Set s;
            Set set = s = (Set)o;
            synchronized (set) {
                for (byte[] v : values) {
                    s.add(new ByteWrap(v));
                }
            }
            return s.size();
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Set"});
    }

    @Override
    public Long scard(String key) {
        return this.scard(SafeEncoder.encode((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return 0L;
        }
        if (o instanceof Set) {
            Set s;
            Set set = s = (Set)o;
            synchronized (set) {
                return s.size();
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Set"});
    }

    @Override
    public Set<String> smembers(String key) {
        Set<byte[]> bytes = this.smembers(SafeEncoder.encode((String)key));
        HashSet<String> sSet = new HashSet<String>(bytes.size());
        bytes.forEach(b -> sSet.add(SafeEncoder.encode((byte[])b)));
        return sSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> smembers(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return new HashSet<byte[]>(0);
        }
        if (o instanceof Set) {
            Set s;
            Set set = s = (Set)o;
            synchronized (set) {
                TreeSet<byte[]> set2 = new TreeSet<byte[]>(new ByteComparator());
                s.forEach(b -> set2.add(b.getBytes()));
                return set2;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Set"});
    }

    @Override
    public Long srem(String key, String[] values) {
        return this.srem(SafeEncoder.encode((String)key), SafeEncoder.encodeMany((String[])values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(byte[] key, byte[] ... values) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return 0L;
        }
        if (o instanceof Set) {
            Set s;
            Set set = s = (Set)o;
            synchronized (set) {
                for (byte[] v : values) {
                    s.remove(new ByteWrap(v));
                }
                return values.length;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Set"});
    }

    @Override
    public Set<String> keys(String key) {
        Set<byte[]> bytes = this.keys(SafeEncoder.encode((String)key));
        HashSet<String> sSet = new HashSet<String>(bytes.size());
        bytes.forEach(b -> sSet.add(SafeEncoder.encode((byte[])b)));
        return sSet;
    }

    @Override
    public Set<byte[]> keys(byte[] key) {
        String keyStr = SafeEncoder.encode((byte[])key);
        TreeSet<byte[]> set = new TreeSet<byte[]>(new ByteComparator());
        if (keyStr.contains("*") && keyStr.length() > 1) {
            String prefix = keyStr.substring(0, keyStr.indexOf("*"));
            this.cache.forEach(k -> {
                ByteWrap kWrap = (ByteWrap)k.getKey();
                String kStr = SafeEncoder.encode((byte[])kWrap.getBytes());
                if (kStr.startsWith(prefix)) {
                    set.add(kWrap.getBytes());
                }
            });
        } else {
            this.cache.forEach(k -> set.add(((ByteWrap)k.getKey()).getBytes()));
        }
        return set;
    }

    private Cache<ByteWrap, Object> newCache(String region, int timeout, int maxHeapSize, int maxItemSize) {
        CacheManager manager = EhcacheFactory.getCacheManager();
        if (maxItemSize < 1) {
            maxItemSize = Integer.getInteger("redis.ehcache.limit.maxitems", Integer.MAX_VALUE);
        }
        ResourcePoolsBuilder builder = ResourcePoolsBuilder.heap((long)maxItemSize);
        Cache cache = manager.createCache(region, CacheConfigurationBuilder.newCacheConfigurationBuilder(ByteWrap.class, Object.class, (Builder)builder).withExpiry(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofSeconds(timeout))).build());
        return cache;
    }

    private int getDefaultTimeout() {
        String s = System.getProperty(DEFAULT_TIMEOUT_KEY);
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception t) {
                DisCardUtil.discard();
            }
        }
        return 3600;
    }

    @Override
    public Long setnx(String key, String value) {
        return this.setnx(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        ByteWrap _key = new ByteWrap(key);
        ByteWrap _value = new ByteWrap(value);
        int timeoutSeconds = this.getDefaultTimeout();
        Object o = this.cache.get((Object)_key);
        if (o == null) {
            this.cache.put((Object)_key, (Object)_value);
            this.expire(key, timeoutSeconds);
            return 1L;
        }
        return 0L;
    }

    @Override
    public byte[] get(byte[] key) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return null;
        }
        if (o instanceof ByteWrap) {
            return ((ByteWrap)o).getBytes();
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"String"});
    }

    @Override
    public Long del(byte[] key) {
        this.cache.remove((Object)new ByteWrap(key));
        return 1L;
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        this.expireKeyMap.put(new ByteWrap(key), System.currentTimeMillis() + 1000L * (long)seconds);
        return 1L;
    }

    @Override
    public Long expire(byte[] key, long seconds) {
        this.expireKeyMap.put(new ByteWrap(key), System.currentTimeMillis() + 1000L * seconds);
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> keyValues) {
        Object o;
        ByteWrap _key = new ByteWrap(key);
        if (!this.exists(key).booleanValue()) {
            JedisFakeEhcache jedisFakeEhcache = this;
            synchronized (jedisFakeEhcache) {
                if (!this.exists(key).booleanValue()) {
                    this.cache.put((Object)_key, new ConcurrentHashMap());
                }
            }
        }
        if ((o = this.cache.get((Object)_key)) instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                keyValues.forEach((k, v) -> m.put(new ByteWrap((byte[])k), new ByteWrap((byte[])v)));
            }
            return "ok";
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public Boolean exists(byte[] key) {
        return this.cache.containsKey((Object)new ByteWrap(key));
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        Object o = this.cache.get((Object)new ByteWrap(key));
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            ByteWrap val = (ByteWrap)m.get(new ByteWrap(field));
            if (val == null) {
                return null;
            }
            return val.getBytes();
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        ByteWrap _key = new ByteWrap(key);
        Object o = this.cache.get((Object)_key);
        if (o == null) {
            int len = fields.length;
            ArrayList<byte[]> list = new ArrayList<byte[]>(len);
            for (int i = 0; i < len; ++i) {
                list.add(null);
            }
            return list;
        }
        if (o instanceof Map) {
            Map m;
            Map map = m = (Map)o;
            synchronized (map) {
                ArrayList<byte[]> ls = new ArrayList<byte[]>(2);
                for (byte[] hkey : fields) {
                    ByteWrap k = new ByteWrap(hkey);
                    ByteWrap val = (ByteWrap)m.get(k);
                    if (val != null) {
                        ls.add(val.getBytes());
                        continue;
                    }
                    ls.add(null);
                }
                return ls;
            }
        }
        throw new KDException(FakeErrorCode.redisTypeNotMatch, new Object[]{"Map"});
    }

    @Override
    public void $$clear() {
        this.cache.clear();
    }

    static class ByteComparator
    implements Comparator<byte[]> {
        ByteComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            return Arrays.hashCode(o1) - Arrays.hashCode(o2);
        }
    }
}

