/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fake.zookeeper;

import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class EmbedZookeeperService {
    public static void startStandaloneServer(String tickTime, String dataDir, String clientPort, String initLimit, String syncLimit) {
        Properties props = new Properties();
        props.setProperty("tickTime", tickTime);
        props.setProperty("dataDir", dataDir);
        props.setProperty("clientPort", clientPort);
        props.setProperty("initLimit", initLimit);
        props.setProperty("syncLimit", syncLimit);
        QuorumPeerConfig quorumConfig = new QuorumPeerConfig();
        try {
            quorumConfig.parseProperties(props);
            ZooKeeperServerMain zkServer = new ZooKeeperServerMain();
            ServerConfig config = new ServerConfig();
            config.readFrom(quorumConfig);
            zkServer.runFromConfig(config);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[0]);
        }
    }

    public static void main(String[] args) {
        try {
            EmbedZookeeperService.startStandaloneServer("2000", System.getProperty("embed.zookeeper.dir"), System.getProperty("embed.zookeeper.port"), "10", "5");
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{"can't found actionconfig.xml"});
        }
    }
}

