/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import kd.bos.nacos.NacosConfigService;
import kd.bos.nacos.NacosFactory;

public class NacosConfigClient
implements NacosConfigService {
    private String serverAddress;
    private ConfigService configService;

    public NacosConfigClient(String serverAddress, ConfigService configService) {
        this.serverAddress = serverAddress;
        this.configService = configService;
    }

    private int getNacosRequestTimeout() {
        return Integer.getInteger("nacos.request.timeoutms", 10000);
    }

    @Override
    public String getConfig(String dataId, String group) throws NacosException {
        return this.configService.getConfig(dataId, group, (long)this.getNacosRequestTimeout());
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws NacosException {
        return this.configService.getConfig(dataId, group, timeoutMs);
    }

    @Override
    public String getConfigAndSignListener(String dataId, String group, Listener listener) throws NacosException {
        return this.configService.getConfigAndSignListener(dataId, group, (long)this.getNacosRequestTimeout(), listener);
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.configService.addListener(dataId, group, listener);
    }

    @Override
    public boolean publishConfig(String dataId, String group, String content, ConfigType type) throws NacosException {
        return this.configService.publishConfig(dataId, group, content, type.toString());
    }

    @Override
    public boolean publishConfigCas(String dataId, String group, String content, String casMd5, ConfigType type) throws NacosException {
        return this.configService.publishConfigCas(dataId, group, content, casMd5, type.toString());
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.configService.removeConfig(dataId, group);
    }

    public void removeListener(String dataId, String group, Listener listener) {
        this.configService.removeListener(dataId, group, listener);
    }

    public String getServerStatus() {
        return this.configService.getServerStatus();
    }

    public void shutDown() throws NacosException {
        this.configService.shutDown();
        NacosFactory.removeConfigService(this.serverAddress);
    }
}

