/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.script.ScriptSecurityMode;
import kd.bos.script.jsengine.KBigDecimalScale;
import kd.bos.util.ConfigurationUtil;

public final class ScriptConfig {
    private static long timeOut = 600000L;
    private static long debugTimeOut = 3600000L;
    private static long maxInstructions = 1000000000L;
    private static int decimalDefaultScale = 17;
    private static int decimalDefaultRoundingMode = 4;
    private static ScriptSecurityMode scriptSecurityMode;
    private static String[] topPackageNames;
    private static Set<String> allowedSet;
    private static Set<String> forbiddenSet;

    private ScriptConfig() {
    }

    private static void onSecurityModelChanged(String model) {
        String strictModel = (model != null ? model : System.getProperty("script.security.model", "normal")).toUpperCase();
        try {
            scriptSecurityMode = ScriptSecurityMode.valueOf(strictModel);
        }
        catch (Exception e) {
            scriptSecurityMode = ScriptSecurityMode.NORMAL;
        }
        String packages = System.getProperty("kd.script.packages");
        if (packages == null || packages.length() == 0) {
            switch (scriptSecurityMode) {
                case NOLIMIT: {
                    packages = "kd,java,javax,or,com,edu,net";
                    break;
                }
                default: {
                    packages = "kd";
                }
            }
        }
        topPackageNames = packages.split(",");
    }

    private static void onAllowedChanged(String s) {
        allowedSet = ScriptConfig.string2Set(s);
    }

    private static void onForbiddenChanged(String s) {
        forbiddenSet = ScriptConfig.string2Set(s);
    }

    private static Set<String> string2Set(String s) {
        if (s == null || s.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String cls : s.split(",")) {
            if ((cls = cls.trim()).isEmpty()) continue;
            set.add(cls);
        }
        return set;
    }

    public static boolean isForbiddenBySecurity(String cls) {
        return forbiddenSet.contains(cls);
    }

    public static boolean isAllowedBySecurity(String cls) {
        return allowedSet.contains(cls);
    }

    public static String[] getTopPackageNames() {
        return topPackageNames;
    }

    public static boolean isStrictMode() {
        return scriptSecurityMode == ScriptSecurityMode.STRICT;
    }

    public static ScriptSecurityMode getScriptSecurityMode() {
        return scriptSecurityMode;
    }

    public static long getTimeOut() {
        return timeOut;
    }

    public static long getDebugTimeOut() {
        return debugTimeOut;
    }

    public static long getMaxInstructions() {
        return maxInstructions;
    }

    public static int getDecimalDefaultScale() {
        return decimalDefaultScale;
    }

    public static int getDecimalDefaultRoundingMode() {
        return decimalDefaultRoundingMode;
    }

    static {
        allowedSet = new HashSet<String>();
        forbiddenSet = new HashSet<String>();
        ConfigurationUtil.observeInteger((String)"script.timeout", (int)10, t -> {
            timeOut = t * 60 * 1000;
        });
        ConfigurationUtil.observeInteger((String)"script.debug.timeout", (int)60, t -> {
            debugTimeOut = t * 60 * 1000;
        });
        ConfigurationUtil.observeLong((String)"kscript.maxInstructions", (long)maxInstructions, v -> {
            maxInstructions = v;
        });
        ConfigurationUtil.observeInteger((String)"script.decimal.scale", (int)decimalDefaultScale, v -> {
            if (decimalDefaultScale != v) {
                decimalDefaultScale = v;
                KBigDecimalScale.initDefaultScaleContext();
            }
        });
        ConfigurationUtil.observeString((String)"script.decimal.roundingMode", (String)String.valueOf(decimalDefaultRoundingMode), v -> {
            int v2 = KBigDecimalScale.parseRoundingMode(v);
            if (decimalDefaultRoundingMode != v2) {
                decimalDefaultRoundingMode = v2;
                KBigDecimalScale.initDefaultScaleContext();
            }
        });
        ConfigurationUtil.observeString((String)"script.security.model", (String)"normal", v -> ScriptConfig.onSecurityModelChanged(v));
        String allowed = "java.io.BufferedReader,java.io.ByteArrayInputStream,java.io.ByteArrayOutputStream,java.io.IOException,java.io.InputStream,java.io.InputStreamReader";
        String forbidden = "java.lang.Runtime,java.lang.ProcessBuilder";
        ConfigurationUtil.observeString((String)"script.security.allowed", (String)"java.io.BufferedReader,java.io.ByteArrayInputStream,java.io.ByteArrayOutputStream,java.io.IOException,java.io.InputStream,java.io.InputStreamReader", v -> ScriptConfig.onAllowedChanged(v));
        ConfigurationUtil.observeString((String)"script.security.forbidden", (String)"java.lang.Runtime,java.lang.ProcessBuilder", v -> ScriptConfig.onForbiddenChanged(v));
    }
}

