/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.script.Initializer;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptTracker;
import kd.bos.script.debug.DebugConfig;
import kd.bos.script.debug.DebugThreadType;
import kd.bos.script.jsengine.KContextFactory;
import kd.bos.script.jsengine.KExecutor;
import kd.bos.script.jsengine.debug.DebugIdThread;
import kd.bos.script.util.ScriptType;
import kd.bos.script.util.ThreadLocalEx;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.KVMBridge;

public class ScriptExecutorFactory {
    private static final ThreadLocalEx<ScriptExecutor> TH_SCRIPT_EXECUTOR = new ThreadLocalEx();
    private static final AtomicLong EXECUTOR_SEQ = new AtomicLong();
    private static final boolean USE_SEPARATED_CLASS_LOADER = false;

    private static ClassLoader getAppClassLoader() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        return ccl == null ? ScriptExecutorFactory.class.getClassLoader() : ccl;
    }

    static ScriptExecutor create() {
        return ScriptExecutorFactory.create(false);
    }

    static ScriptExecutor create(boolean safeModel) {
        return ScriptExecutorFactory.create(ScriptType.JAVASCRIPT, safeModel);
    }

    static ScriptExecutor create(ScriptType type) {
        return ScriptExecutorFactory.create(type, false);
    }

    static ScriptExecutor create(ScriptType type, boolean safeModel) {
        if (type == null) {
            type = ScriptType.JAVASCRIPT;
        }
        switch (type) {
            case JAVASCRIPT: {
                KExecutor executor = new KExecutor(ScriptExecutorFactory.getAppClassLoader(), safeModel);
                return ScriptExecutorFactory.__onCreate(executor);
            }
        }
        throw new UnsupportedOperationException("Not supported: " + (Object)((Object)type));
    }

    private static ScriptExecutor __onCreate(ScriptExecutor executor) {
        String debugId;
        if (DebugConfig.isDebugEnabled() && (debugId = DebugIdThread.getDebugId()) != null) {
            ((KExecutor)executor).attachDebug(debugId);
        }
        return executor;
    }

    public static void setupThreadDebug(String debugId, DebugThreadType threadType) {
        DebugIdThread.set(debugId, threadType);
    }

    public static void clearThreadDebug(String debugId) {
        DebugIdThread.remove();
    }

    public static String getThreadDebugId() {
        return DebugIdThread.getDebugId();
    }

    public static DebugThreadType getDebugThreadType() {
        return DebugIdThread.getDebugThreadType();
    }

    public static ScriptExecutor getCurrentScriptExecutor() {
        return TH_SCRIPT_EXECUTOR.get();
    }

    public static void setCurrentScriptExecutor(ScriptExecutor executor) {
        TH_SCRIPT_EXECUTOR.set(executor);
    }

    public static void removeCurrentScriptExecutor() {
        if (ScriptTracker.on()) {
            Thread currentThread = Thread.currentThread();
            ScriptExecutor currentScriptExecutor = TH_SCRIPT_EXECUTOR.get();
            ScriptTracker.track("removeCurrentScriptExecutor currentThread=" + currentThread);
            ScriptTracker.track("removeCurrentScriptExecutor thScriptExecutor=#" + currentScriptExecutor);
            TH_SCRIPT_EXECUTOR.remove();
            DebugIdThread.remove();
            ScriptTracker.track(Resources.getString((String)"\u68c0\u67e5thScriptExecutor\u4e2dScriptExecutor\u7ebf\u7a0b\u5bf9\u8c61(\u82e5\u65e0\u5e76\u53d1\u5219\u5e94\u4e3a0)=", (String)"ScriptExecutorFactory_0", (String)"bos-serverscript", (Object[])new Object[0]) + TH_SCRIPT_EXECUTOR.keys().size());
            int i = 0;
            for (Thread t : TH_SCRIPT_EXECUTOR.keys()) {
                ScriptTracker.track(++i + " " + t + "=#" + TH_SCRIPT_EXECUTOR.get(t));
                ScriptTracker.track(i + Resources.getString((String)" \u540c\u7ebf\u7a0b=", (String)"ScriptExecutorFactory_1", (String)"bos-serverscript", (Object[])new Object[0]) + (currentThread == t));
                if (currentScriptExecutor == null) continue;
                ScriptTracker.track(i + Resources.getString((String)" \u540cScriptExecutor=", (String)"ScriptExecutorFactory_2", (String)"bos-serverscript", (Object[])new Object[0]) + (TH_SCRIPT_EXECUTOR.get(t) == currentScriptExecutor));
            }
        } else {
            TH_SCRIPT_EXECUTOR.remove();
            DebugIdThread.remove();
        }
    }

    public static void removeScriptExecutorByDebug(String debugId) {
        DebugIdThread.remove(debugId, t -> {
            TH_SCRIPT_EXECUTOR.remove((Thread)t);
            KVMBridge.doExist((Thread)t);
            return null;
        });
    }

    static ScriptExecutor getOrCreate() {
        final ScriptExecutor executor = ScriptExecutorFactory.getCurrentScriptExecutor();
        if (executor == null) {
            return ScriptExecutorFactory.create();
        }
        return (ScriptExecutor)Proxy.newProxyInstance(ScriptExecutor.class.getClassLoader(), executor.getClass().getInterfaces(), new InvocationHandler(){
            private Initializer initializer;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName;
                switch (methodName = method.getName()) {
                    case "init": {
                        this.initializer = (Initializer)args[0];
                        return null;
                    }
                    case "begin": {
                        if (this.initializer != null) {
                            this.initializer.init(executor.getContext());
                            this.initializer = null;
                        }
                        return null;
                    }
                    case "end": {
                        return null;
                    }
                    case "endAll": {
                        return null;
                    }
                }
                return method.invoke((Object)executor, args);
            }
        });
    }

    static {
        KContextFactory.init();
    }
}

