/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.Locale;
import kd.bos.script.ScriptConfig;
import kd.bos.script.ScriptExecutorFactory;
import kd.bos.script.jsengine.KExecutor;
import kd.bos.script.jsengine.KExecutorListener;

public final class KBigDecimalScale {
    private static DecimalScaleContext DEFAULT_DECIMAL_SCALE_CONTEXT;
    private static final String DECIMAL_SCALE_CONTEXT_ATTR = "DECIMAL_SCALE_CONTEXT";
    private static ThreadLocal<DecimalScaleContext> th;

    public static void initDefaultScaleContext() {
        DEFAULT_DECIMAL_SCALE_CONTEXT = new DecimalScaleContext(ScriptConfig.getDecimalDefaultScale(), ScriptConfig.getDecimalDefaultRoundingMode(), null);
    }

    public static void setupBigDecimalScaleCleaner(KExecutor executor) {
        executor.addExecutorListener(new KExecutorListener(){
            int from = 0;

            @Override
            public void onStart() {
                LinkedList list = KBigDecimalScale.getBigDecimalScaleContextList();
                if (list != null) {
                    this.from = list.size();
                }
            }

            @Override
            public void onStop() {
                LinkedList list = KBigDecimalScale.getBigDecimalScaleContextList();
                if (list != null && !list.isEmpty()) {
                    while (list.size() > this.from) {
                        KBigDecimalScale.endBigDecimalScale();
                    }
                }
            }
        });
    }

    private static LinkedList<DecimalScaleContext> getBigDecimalScaleContextList() {
        return (LinkedList)((KExecutor)ScriptExecutorFactory.getCurrentScriptExecutor()).getAttribute(DECIMAL_SCALE_CONTEXT_ATTR);
    }

    public static void beginBigDecimalScale(int scale, int roundingMode) {
        DecimalScaleContext ctx = new DecimalScaleContext(scale, roundingMode, th.get());
        th.set(ctx);
        LinkedList<DecimalScaleContext> list = KBigDecimalScale.getBigDecimalScaleContextList();
        if (list == null) {
            list = new LinkedList();
            KExecutor executor = (KExecutor)ScriptExecutorFactory.getCurrentScriptExecutor();
            executor.setAttribuite(DECIMAL_SCALE_CONTEXT_ATTR, list);
        }
        list.add(ctx);
    }

    public static void endBigDecimalScale() {
        DecimalScaleContext ctx = th.get();
        LinkedList<DecimalScaleContext> list = KBigDecimalScale.getBigDecimalScaleContextList();
        if (ctx != null) {
            if (ctx.parent == null) {
                th.remove();
                if (list != null) {
                    list.clear();
                }
            } else {
                th.set(ctx.parent);
                if (list != null) {
                    list.removeLast();
                }
            }
        } else if (list != null) {
            list.clear();
        }
    }

    public static BigDecimal limitMaxScale(BigDecimal val) {
        DecimalScaleContext ctx = KBigDecimalScale.getDecimalScaleContextWithDefault();
        if (val.scale() <= ctx.scale) {
            return val;
        }
        return val.setScale(ctx.scale, ctx.roundingMode);
    }

    public static DecimalScaleContext getDecimalScaleContextWithDefault() {
        DecimalScaleContext ctx = th.get();
        if (ctx == null) {
            ctx = DEFAULT_DECIMAL_SCALE_CONTEXT;
        }
        return ctx;
    }

    public static DecimalScaleContext getDefaultDecimalScaleContext() {
        return DEFAULT_DECIMAL_SCALE_CONTEXT;
    }

    public static int parseRoundingMode(Object roundingMode) {
        if (roundingMode == null) {
            return KBigDecimalScale.DEFAULT_DECIMAL_SCALE_CONTEXT.roundingMode;
        }
        if (roundingMode instanceof Number) {
            return ((Number)roundingMode).intValue();
        }
        String value = String.valueOf(roundingMode);
        if (value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        if ((value = value.toUpperCase(Locale.ENGLISH)).startsWith("ROUND_")) {
            value = value.substring(6);
        }
        return RoundingMode.valueOf(value).ordinal();
    }

    static {
        KBigDecimalScale.initDefaultScaleContext();
        th = new ThreadLocal();
    }

    public static class DecimalScaleContext {
        public final int scale;
        public final int roundingMode;
        private final DecimalScaleContext parent;

        DecimalScaleContext(int scale, int roundingMode, DecimalScaleContext parent) {
            this.scale = scale;
            this.roundingMode = roundingMode;
            this.parent = parent;
        }

        public String toString() {
            return "{scale: " + this.scale + ", roundingMode: " + this.roundingMode + ", parent: " + this.parent + "}";
        }
    }
}

