/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.script.Initializer;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.ScriptConfig;
import kd.bos.script.ScriptContext;
import kd.bos.script.ScriptObject;
import kd.bos.script.ScriptTracker;
import kd.bos.script.Todo;
import kd.bos.script.VarProvider;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.jsengine.KErrorCollector;
import kd.bos.script.jsengine.KRuntime;
import kd.bos.script.jsengine.KScope;
import kd.bos.script.jsengine.KUtil;
import kd.bos.script.jsengine.debug.DebugIdThread;
import kd.bos.script.jsengine.def.KNamespace;
import kd.bos.script.jsengine.def.typemap.KJsType;
import kd.bos.script.jsengine.mate.KClassShutter;
import kd.bos.script.jsengine.mate.KContextEnv;
import kd.bos.script.jsengine.mate.KSecurityController;
import kd.bos.script.jsengine.mate.KSecurityDomain;
import kd.bos.script.jsengine.mate.KWrapFactory;
import kd.bos.script.log.KScriptLogable;
import kd.bos.script.util.LRUCacheMap;
import kd.bos.script.util.ScriptLookup;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.KVMBridge;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.Debugger;

public final class KContext
extends Context
implements ScriptContext,
KScriptLogable {
    private Set<WeakReference<ScriptObject>> allScriptObjectSet = new HashSet<WeakReference<ScriptObject>>();
    private ClassLoader classLoader;
    private boolean safeModel;
    private ScriptLookup scriptLookup;
    private long startTime;
    private long timeout;
    private long debugTimeout;
    private long maxInstructions;
    private long currentInstructions;
    private KScope scope;
    private KSecurityDomain securityDomain;
    private VarProvider vp;
    private boolean definingInnerClass = false;
    private boolean maskDebugFlag = false;
    private Debugger mask_debugger;
    private Object mask_contextData;
    private int mask_optimizationLevel;
    private boolean mask_generatingDebug;
    private boolean validateModel;
    private Map<String, Method> methodMatchCacheMap = Collections.synchronizedMap(new LRUCacheMap(1000));

    public static KContext get() {
        return (KContext)KContext.getCurrentContext();
    }

    public KContext(ContextFactory factory) {
        super(factory);
        this.setOptimizationLevel(-1);
        this.setLanguageVersion(200);
        this.setValidateModel(false);
        this.setLimit(ScriptConfig.getTimeOut(), ScriptConfig.getDebugTimeOut(), ScriptConfig.getMaxInstructions(), 100000);
    }

    public void setValidateModel(boolean validateModel) {
        if (this.validateModel == validateModel) {
            return;
        }
        this.validateModel = validateModel;
        this.setErrorReporter(new KErrorCollector(validateModel));
    }

    protected CompilerEnvirons createCompilerEnvirons() {
        if (this.validateModel) {
            return CompilerEnvirons.ideEnvirons();
        }
        return super.createCompilerEnvirons();
    }

    public void maskDebug(boolean maskDebug) {
        if (this.maskDebugFlag == maskDebug) {
            return;
        }
        if (maskDebug) {
            this.mask_debugger = this.getDebugger();
            this.mask_contextData = this.getDebuggerContextData();
            this.mask_optimizationLevel = this.getOptimizationLevel();
            this.mask_generatingDebug = this.isGeneratingDebug();
            this.setDebugger(null, null);
            this.setOptimizationLevel(-1);
            this.setGeneratingDebug(false);
        } else {
            this.setGeneratingDebug(this.mask_generatingDebug);
            this.setOptimizationLevel(this.mask_optimizationLevel);
            this.setDebugger(this.mask_debugger, this.mask_contextData);
        }
        this.maskDebugFlag = maskDebug;
    }

    public boolean isDebugModel() {
        if (this.maskDebugFlag) {
            return false;
        }
        return super.isDebugModel();
    }

    public boolean isDefiningInnerClass() {
        return this.definingInnerClass;
    }

    void init(ClassLoader appLoader, boolean safeModel, boolean firstEnter) {
        this.classLoader = appLoader;
        this.safeModel = safeModel;
        if (this.getScope() == null) {
            this.setScope(new KScope());
        }
        this.startTime = System.currentTimeMillis();
        if (firstEnter) {
            this.setWrapFactory(KWrapFactory.INSTANCE);
            this.setSecurityController(new KSecurityController());
            Context.ClassShutterSetter classShutterSetter = this.getClassShutterSetter();
            if (classShutterSetter != null) {
                classShutterSetter.setClassShutter((ClassShutter)KClassShutter.INSTANCE);
            }
        }
        this.getClassShutter().setSafeModel(safeModel);
        if (safeModel) {
            this.initSafeStandardObjects((ScriptableObject)this.scope);
            this.getClassShutter().setAllow(".*");
        } else {
            this.initStandardObjects((ScriptableObject)this.scope);
        }
        this.defineInitClasses(KUtil.loadDefineFile("/conf/internal_kscript_define_class.conf", true), true);
        this.defineInitObjects(KUtil.loadDefineFile("/conf/internal_kscript_define_object.conf", true));
        this.defineInitClasses(KUtil.loadDefineFile("/conf/kscript_define_class.conf", true), true);
        this.defineInitObjects(KUtil.loadDefineFile("/conf/kscript_define_object.conf", true));
        Class<?> scopeCls = ((Object)((Object)this.scope)).getClass();
        this.scope.defineFunctionProperties(KUtil.getExportNames(scopeCls), scopeCls, 2);
    }

    protected int defineInitClasses(String defs, boolean inner) {
        if (defs == null || defs.length() == 0) {
            return 0;
        }
        try {
            if (inner) {
                this.definingInnerClass = true;
            }
            List<String> list = KUtil.toDefineClassConfig(defs);
            for (String cls : list) {
                this.require(cls);
            }
            int n = list.size();
            return n;
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
        finally {
            if (inner) {
                this.definingInnerClass = false;
            }
        }
    }

    protected void defineInitObjects(String defs) {
        try {
            List<String[]> list = KUtil.toDefineVarConfig(defs);
            for (String[] pair : list) {
                String var = pair[0];
                Class<?> scritableCls = Class.forName(pair[1]);
                this.defineConst(var, scritableCls, new Object[0]);
            }
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    static KContext begin(ClassLoader classLoader, boolean safeModel, Initializer si) {
        String debugId;
        KContext context = (KContext)KContext.enter();
        KContextEnv.onBegin(context);
        context.init(classLoader, safeModel, KVMBridge.getEnterCount() == 1);
        if (si != null) {
            si.init(context);
        }
        if ((debugId = DebugIdThread.getDebugId()) != null) {
            DebugManager.getDebugCache(debugId).set("_inner_context", context);
        }
        return context;
    }

    public void end() {
        KContextEnv.onEnd(this);
    }

    public void __releaseAllScriptObject() {
        this.allScriptObjectSet.forEach(obj -> {
            if (obj.get() != null) {
                ((ScriptObject)obj.get()).__release();
                obj.clear();
            }
        });
        ScriptTracker.track("KContext.end: clear allScriptObjectSet=" + this.allScriptObjectSet.size());
        this.allScriptObjectSet.clear();
    }

    void setScope(KScope scope) {
        this.scope = scope;
    }

    public KScope getScope() {
        return this.scope;
    }

    public synchronized KClassShutter getClassShutter() {
        return KClassShutter.INSTANCE;
    }

    protected void onStart() {
        Todo.todo(Resources.getString((String)"\u8ba1\u65f6\u7b49\u811a\u672c\u76d1\u63a7", (String)"KContext_0", (String)"bos-serverscript", (Object[])new Object[0]));
    }

    protected Object onError(Throwable e) {
        log.warn(e.getMessage(), e);
        return e;
    }

    protected void onStop() {
    }

    @Override
    public <T> T get(String var) {
        return (T)KJsType.js2java(this.scope.get(var));
    }

    @Override
    public void set(String var, Object value) {
        this.scope.put(var, (Scriptable)this.scope, KJsType.java2js(value, (Scriptable)this.scope));
    }

    @Override
    public void setConst(String var, Object value) {
        this.scope.putConst(var, (Scriptable)this.scope, KJsType.java2js(value, (Scriptable)this.scope));
    }

    final void importClass(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            KNamespace.defineNamespace((Scriptable)this.scope, KJsType.getJSNameSpace(cls), cls);
        }
    }

    int importModule(URL moduleConfURL) {
        return this.defineInitClasses(KUtil.loadDefineFile(moduleConfURL), false);
    }

    @Override
    public void require(String ... modulesOrClasses) {
        if (modulesOrClasses == null) {
            return;
        }
        for (String res : modulesOrClasses) {
            if ((res = res.trim()).indexOf(47) != -1) {
                this.defineInitClasses(KUtil.loadDefineFile(res, false), false);
                continue;
            }
            try {
                Class<?> cls = Class.forName(res);
                KNamespace.defineNamespace((Scriptable)this.scope, KJsType.getJSNameSpace(cls), cls);
            }
            catch (Exception e) {
                throw KRuntime.wrapRuntimeException(e);
            }
        }
    }

    private ScriptObject defineConst(String constName, Class<? extends ScriptObject> scritableCls, Object ... constructArgs) {
        ScriptObject jsObject = this.createObject(scritableCls, constructArgs);
        this.setConst(constName, jsObject);
        return jsObject;
    }

    public ScriptObject createObject(Class<? extends ScriptObject> scritableCls, Object ... constructArgs) {
        try {
            this.importClass(scritableCls);
            String scriptableClsName = KJsType.getJSTypeName(scritableCls);
            if (constructArgs == null) {
                constructArgs = ScriptRuntime.emptyArgs;
            }
            Object clsScope = this.scope;
            String namespace = KJsType.getJSNameSpace(scritableCls);
            if (namespace.length() > 0) {
                clsScope = KNamespace.defineNamespace((Scriptable)this.scope, namespace);
            }
            Scriptable jsObject = this.newObject((Scriptable)clsScope, scriptableClsName, constructArgs);
            return (ScriptObject)jsObject;
        }
        catch (Exception e) {
            throw KRuntime.wrapRuntimeException(e);
        }
    }

    public Scriptable createObject(String namespace, String jsTypeName, Object ... constructArgs) {
        Object clsScope = this.scope;
        if (namespace != null && namespace.trim().length() > 0) {
            clsScope = KNamespace.defineNamespace((Scriptable)this.scope, namespace);
        }
        return this.newObject((Scriptable)clsScope, jsTypeName, constructArgs);
    }

    public final boolean isSafeModel() {
        return this.safeModel;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setLimit(long timeout, long debugTimeout, long maxInstructions, int instructionObserverThreshold) {
        this.timeout = timeout;
        this.debugTimeout = debugTimeout;
        this.maxInstructions = maxInstructions;
        this.setInstructionObserverThreshold(instructionObserverThreshold);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getDebugTimeout() {
        return this.debugTimeout;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getMaxInstructions() {
        return this.maxInstructions;
    }

    public long getCurrentInstructions() {
        return this.currentInstructions;
    }

    public void setCurrentInstructions(long currentInstructions) {
        this.currentInstructions = currentInstructions;
    }

    public KSecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(KSecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public ScriptLookup getScriptLookup() {
        return this.scriptLookup;
    }

    @Override
    public void setScriptLookup(ScriptLookup scriptLookup) {
        this.scriptLookup = scriptLookup;
    }

    public void addScriptObject(ScriptObject so) {
        this.allScriptObjectSet.add(new WeakReference<ScriptObject>(so));
    }

    @Override
    public void setVarProvider(VarProvider vp) {
        this.vp = vp;
    }

    public VarProvider getVarProvider() {
        return this.vp;
    }

    @Override
    public Set<ScriptClassInfo> getDefinedClasses() {
        return KJsType.getDefinedClasses(false);
    }

    @Override
    public Set<ScriptClassInfo> getAllDefinedClasses() {
        return KJsType.getDefinedClasses(true);
    }

    public Map<String, Method> getMethodMatchCache() {
        return this.methodMatchCacheMap;
    }
}

