/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.script.jsengine.KRuntimeException;
import kd.bos.script.jsengine.def.KObjectConverter;
import kd.bos.script.jsengine.def.typemap.KJsType;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public final class KRuntime {
    private static final Map<Class<?>, Integer> clsOrderMap = new HashMap();
    private static final int UNIT = 100;
    private static final int FULL_UNIT = 1000000;
    private static final int NOT_MATCH_ARRAY = 1;
    private static final BigDecimal max_d;
    private static final BigDecimal min_d;
    private static final BigDecimal max_long;
    private static final BigDecimal min_long;

    public static Callable<?> matchConstructor(Class<?> beanCls, Object[] args, Context cx) {
        Constructor<?> matched = null;
        Constructor<?>[] cs = beanCls.getConstructors();
        MatchResult maxWeightResult = null;
        for (Constructor<?> c : cs) {
            MatchResult weightResult = KRuntime.getMatchWeight(c.getParameterTypes(), args);
            if (weightResult == null || maxWeightResult != null && weightResult.weight <= maxWeightResult.weight) continue;
            maxWeightResult = weightResult;
            matched = c;
        }
        if (matched != null && maxWeightResult != null) {
            Constructor<?> c = matched;
            Object[] matchedArgs = maxWeightResult.args;
            return () -> {
                KRuntime.jsToJava(c.getParameterTypes(), matchedArgs);
                return c.newInstance(matchedArgs);
            };
        }
        return null;
    }

    public static Callable<?> matchMethod(Object obj, List<Method> methods, Object[] args, Scriptable scope, Context cx) {
        MethodInfo mi = KRuntime.matchMethodInfo(obj, methods, args, scope, cx);
        return mi == null ? null : mi.toCallable();
    }

    private static int getParameterTypeWeight(Class<?>[] types) {
        int w = 0;
        for (Class<?> t : types) {
            w += 100;
            if (t == Object.class) {
                ++w;
                continue;
            }
            if (t.isArray()) {
                if (t.getComponentType() == Object.class) {
                    w += 3;
                    continue;
                }
                w += 4;
                continue;
            }
            w += 2;
        }
        if (types[types.length - 1].isArray()) {
            w -= 2;
        }
        return w;
    }

    public static MethodInfo matchMethodInfo(Object obj, List<Method> methods, Object[] args, Scriptable scope, Context cx) {
        Method matched = null;
        MatchResult maxWeightResult = null;
        for (Method method : methods) {
            MatchResult weightResult = KRuntime.getMatchWeight(method.getParameterTypes(), args);
            if (weightResult == null || maxWeightResult != null && weightResult.weight < maxWeightResult.weight) continue;
            boolean select = true;
            if (maxWeightResult != null && weightResult.weight == maxWeightResult.weight) {
                boolean bl = select = KRuntime.getParameterTypeWeight(weightResult.methodParameterTypes) > KRuntime.getParameterTypeWeight(maxWeightResult.methodParameterTypes);
            }
            if (!select) continue;
            maxWeightResult = weightResult;
            matched = method;
        }
        if (matched != null && maxWeightResult != null) {
            return new MethodInfo(obj, matched, maxWeightResult.args, scope);
        }
        int maxWeight = 0;
        int maxWeight_plen = 0;
        int maxWeight_varWeight = 0;
        Object[] matchedArgs = null;
        int len = args == null ? 0 : args.length;
        for (Method method : methods) {
            boolean b;
            Object[] newArgs = null;
            int varWeight = 0;
            Class<?>[] parameterTypes = method.getParameterTypes();
            int plen = parameterTypes.length;
            if (plen <= 0 || !parameterTypes[plen - 1].isArray()) continue;
            int weight = 0;
            Class<?> varCls = parameterTypes[plen - 1].getComponentType();
            if (plen == 1) {
                weight = 1000000;
                if (len > 0) {
                    Class[] varClses = new Class[len];
                    for (int i = 0; i < varClses.length; ++i) {
                        varClses[i] = varCls;
                    }
                    MatchResult varWeightResult = KRuntime.getMatchWeight(varClses, args);
                    int n = varWeight = varWeightResult == null ? 0 : varWeightResult.weight;
                    if (varWeight == 0) continue;
                    Object typedVarArgs = Array.newInstance(varCls, len);
                    for (int i = 0; i < args.length; ++i) {
                        Array.set(typedVarArgs, i, KJsType.js2java(args[i], varCls));
                    }
                    newArgs = new Object[]{typedVarArgs};
                } else {
                    varWeight = 1000000;
                }
            } else {
                if (args == null) continue;
                Class[] preCls = new Class[plen - 1];
                System.arraycopy(parameterTypes, 0, preCls, 0, preCls.length);
                Object[] preArgs = new Object[preCls.length];
                System.arraycopy(args, 0, preArgs, 0, preCls.length);
                MatchResult varWeightResult = KRuntime.getMatchWeight(preCls, preArgs);
                weight = varWeightResult == null ? 0 : varWeightResult.weight;
                if (weight == 0) continue;
                if (len >= plen) {
                    MatchResult i = varWeightResult;
                    weight = i.weight = i.weight - 1;
                    Object[] varArgs = new Object[len - plen + 1];
                    System.arraycopy(args, plen - 1, varArgs, 0, varArgs.length);
                    Class[] varClses = new Class[varArgs.length];
                    for (int i2 = 0; i2 < varClses.length; ++i2) {
                        varClses[i2] = varCls;
                    }
                    varWeightResult = KRuntime.getMatchWeight(varClses, varArgs);
                    int n = varWeight = varWeightResult == null ? 0 : varWeightResult.weight;
                    if (varWeight == 0) continue;
                    newArgs = new Object[plen];
                    System.arraycopy(preArgs, 0, newArgs, 0, plen - 1);
                    Object typedVarArgs = Array.newInstance(varCls, plen);
                    for (int i3 = 0; i3 < varArgs.length; ++i3) {
                        Array.set(typedVarArgs, i3, KJsType.js2java(varArgs[i3], varCls));
                    }
                    newArgs[plen - 1] = typedVarArgs;
                } else {
                    varWeight = 1000000;
                    newArgs = new Object[plen];
                    System.arraycopy(preArgs, 0, newArgs, 0, plen - 1);
                }
            }
            boolean bl = b = weight > maxWeight;
            if (!b && weight == maxWeight) {
                boolean bl2 = b = varWeight > maxWeight_varWeight;
                if (!b && varWeight == maxWeight_varWeight) {
                    boolean bl3 = b = plen > maxWeight_plen;
                }
            }
            if (!b) continue;
            maxWeight = weight;
            maxWeight_plen = plen;
            maxWeight_varWeight = varWeight;
            matched = method;
            matchedArgs = newArgs;
        }
        if (matched != null) {
            return new MethodInfo(obj, matched, matchedArgs, scope);
        }
        return null;
    }

    public static void sortMatchMethod(List<Method> methods) {
        if (methods.size() == 1) {
            return;
        }
        methods.sort(new Comparator<Method>(){

            private int cp(Class<?> c1, Class<?> c2, boolean firstOrLast) {
                if (c1 == c2) {
                    return 0;
                }
                if (c1 == Object[].class) {
                    return 1;
                }
                if (c2 == Object[].class) {
                    return -1;
                }
                if (c1 == Object.class) {
                    return 1;
                }
                if (c2 == Object.class) {
                    return -1;
                }
                if (firstOrLast) {
                    if (c1.isArray()) {
                        c1 = c1.getComponentType();
                    }
                    if (c2.isArray()) {
                        c2 = c2.getComponentType();
                    }
                } else {
                    if (c1.isArray()) {
                        if (c2.isArray()) {
                            return this.cp(c1.getComponentType(), c2.getComponentType(), false);
                        }
                        return 1;
                    }
                    if (c2.isArray()) {
                        return -1;
                    }
                }
                Integer i1 = (Integer)clsOrderMap.get(c1);
                Integer i2 = (Integer)clsOrderMap.get(c2);
                if (i1 == null) {
                    if (i2 == null) {
                        return c1.getName().compareTo(c2.getName());
                    }
                    return 1;
                }
                if (i2 == null) {
                    return -1;
                }
                return i1 - i2;
            }

            @Override
            public int compare(Method m1, Method m2) {
                int dt = m2.getParameterCount() - m1.getParameterCount();
                if (dt == 0) {
                    Class<?>[] ts1 = m1.getParameterTypes();
                    Class<?>[] ts2 = m2.getParameterTypes();
                    int n = ts1.length;
                    for (int i = 0; i < n && (dt = this.cp(ts1[i], ts2[i], i == 0 && n == 1 || i == n - 1)) == 0; ++i) {
                    }
                }
                return dt;
            }
        });
    }

    public static RuntimeException wrapRuntimeException(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new KRuntimeException(e);
    }

    private static Object[] unwrapBigDecimalForMatch(Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] retArgs = new Object[args.length];
        int i = 0;
        for (Object obj : args) {
            if (obj instanceof BigDecimal) {
                BigDecimal dec = (BigDecimal)obj;
                if (dec.scale() == 0) {
                    if (dec.compareTo(max_long) < 0 && dec.compareTo(min_long) > 0) {
                        long v = dec.longValue();
                        obj = v <= Integer.MAX_VALUE && v >= Integer.MIN_VALUE ? (Number)dec.intValue() : (Number)v;
                    }
                } else if (dec.compareTo(min_d) >= 0 && dec.compareTo(max_d) <= 0) {
                    double d = dec.doubleValue();
                    obj = d >= (double)1.4E-45f && d <= 3.4028234663852886E38 ? (Number)Float.valueOf(dec.floatValue()) : (Number)d;
                    obj = dec.doubleValue();
                }
            }
            retArgs[i++] = obj;
        }
        return retArgs;
    }

    private static Object[] cloneArrayIfHasElement(Object[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        Object[] retArgs = new Object[args.length];
        System.arraycopy(args, 0, retArgs, 0, args.length);
        return retArgs;
    }

    private static MatchResult getMatchWeight(Class<?>[] paramTypes, Object[] args) {
        args = KRuntime.unwrapBigDecimalForMatch(args);
        Object[] retArgs = KRuntime.cloneArrayIfHasElement(args);
        int w = KRuntime.doGetMatchWeight(paramTypes, args, false);
        boolean matchArray = false;
        if (w == 0 && args != null && args.length > 0) {
            Object[] newArgs = new Object[args.length];
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                newArgs[i] = KJsType.js2java(args[i]);
            }
            w = KRuntime.doGetMatchWeight(paramTypes, newArgs = KRuntime.unwrapBigDecimalForMatch(newArgs), false);
            if (w == 0) {
                w = KRuntime.doGetMatchWeight(paramTypes, newArgs, true);
                matchArray = true;
            }
            retArgs = newArgs;
        }
        return w == 0 ? null : new MatchResult(w + (matchArray ? 0 : 1), retArgs, paramTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int doGetMatchWeight(Class<?>[] paramTypes, Object[] args, boolean matchArray) {
        int len;
        int n = len = args == null ? 0 : args.length;
        if (paramTypes.length != len) {
            return 0;
        }
        if (len == 0) {
            return 100;
        }
        Class[] argClasses = new Class[len];
        for (int i = 0; i < len; ++i) {
            Object arg = args[i];
            argClasses[i] = arg == null ? null : arg.getClass();
        }
        int ret = 0;
        int full_dd = 1000000 * len;
        int maybe_dd = 10000 * len;
        int one_unit_dd = 100 * len;
        int i = 0;
        while (i < len) {
            block18: {
                Class<?> argCls;
                Class<?> pcls;
                block24: {
                    Integer from;
                    Class<?> original_pcls;
                    block29: {
                        block30: {
                            Integer to;
                            block31: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                Class<?> original_argCls;
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    block17: {
                                                                        pcls = paramTypes[i];
                                                                        argCls = argClasses[i];
                                                                        if (argCls != null) break block17;
                                                                        if (pcls.isPrimitive()) {
                                                                            return 0;
                                                                        }
                                                                        ret += full_dd;
                                                                        break block18;
                                                                    }
                                                                    if (!pcls.isEnum() || argCls != String.class) break block19;
                                                                    ret += full_dd;
                                                                    break block18;
                                                                }
                                                                if (pcls != argCls) break block20;
                                                                ret += full_dd;
                                                                break block18;
                                                            }
                                                            if (!pcls.isAssignableFrom(argCls)) break block21;
                                                            ret += full_dd;
                                                            if (pcls.isAssignableFrom(argCls) && pcls == Object.class && argCls != Object.class && (len != 1 || !argCls.isArray() || argCls.getComponentType() != Object.class || args[0] == null || Array.getLength(args[0]) != 0)) {
                                                                --ret;
                                                            }
                                                            break block18;
                                                        }
                                                        if (!matchArray || !pcls.isArray()) break block22;
                                                        Class<?> cType = pcls.getComponentType();
                                                        boolean matched = true;
                                                        Object argValue = args[i];
                                                        if (argValue == null) {
                                                            if (cType.isPrimitive()) {
                                                                return 0;
                                                            }
                                                        } else if (argCls.isArray()) {
                                                            int an = Array.getLength(argValue);
                                                            for (int j = 0; j < an; ++j) {
                                                                Object obj = KJsType.js2java(Array.get(argValue, j));
                                                                if (!(obj == null && !cType.isPrimitive() || obj != null && cType.isAssignableFrom(obj.getClass()))) {
                                                                    if (!Number.class.isAssignableFrom(KObjectConverter.getObjectType(cType))) return 0;
                                                                    if (obj == null) return 0;
                                                                    if (!Number.class.isAssignableFrom(KObjectConverter.getObjectType(obj.getClass()))) return 0;
                                                                }
                                                                boolean bl = true;
                                                                boolean condition = bl;
                                                                if (condition) continue;
                                                                return 0;
                                                            }
                                                            if (matched) {
                                                                Object argValueArray = Array.newInstance(cType, an);
                                                                for (int j = 0; j < an; ++j) {
                                                                    Array.set(argValueArray, j, KJsType.js2java(Array.get(argValue, j), cType));
                                                                }
                                                                args[i] = argValueArray;
                                                            }
                                                        } else {
                                                            if (!(argValue == null && !cType.isPrimitive() || cType.isAssignableFrom(argValue.getClass()) || cType.isPrimitive() && KObjectConverter.getObjectType(cType) == argValue.getClass())) {
                                                                if (!argValue.getClass().isPrimitive()) return 0;
                                                                if (KObjectConverter.getObjectType(argValue.getClass()) != cType) return 0;
                                                            }
                                                            Object argValueArray = Array.newInstance(cType, 1);
                                                            Array.set(argValueArray, 0, argValue);
                                                            args[i] = argValueArray;
                                                        }
                                                        if (!matched) return 0;
                                                        ret += full_dd;
                                                        break block18;
                                                    }
                                                    original_pcls = pcls;
                                                    original_argCls = argCls;
                                                    if ((pcls = KObjectConverter.getObjectType(pcls)) != (argCls = KObjectConverter.getObjectType(argCls))) break block23;
                                                    ret += full_dd;
                                                    break block24;
                                                }
                                                if (!pcls.isAssignableFrom(argCls)) break block25;
                                                ret = original_pcls.isPrimitive() || original_argCls.isPrimitive() ? (ret += full_dd) : (ret += maybe_dd + 2 * one_unit_dd);
                                                break block24;
                                            }
                                            if (pcls != String.class || argCls != Character.class) break block26;
                                            ret += maybe_dd + 4 * one_unit_dd;
                                            break block24;
                                        }
                                        if (pcls != Character.class || argCls != String.class) break block27;
                                        if (((String)args[i]).length() != 1) return 0;
                                        ret += maybe_dd + 3 * one_unit_dd;
                                        break block24;
                                    }
                                    if (!pcls.isInterface() || !NativeObject.class.isAssignableFrom(argCls)) break block28;
                                    ret += maybe_dd + one_unit_dd;
                                    break block24;
                                }
                                if (!Number.class.isAssignableFrom(pcls) || !Number.class.isAssignableFrom(argCls)) break block29;
                                from = clsOrderMap.get(argCls);
                                to = clsOrderMap.get(pcls);
                                if (from == null || to == null) break block30;
                                if (from > to) break block31;
                                ret += full_dd - (to - from);
                                break block18;
                            }
                            ret += to - from;
                        }
                        ret += maybe_dd + one_unit_dd;
                        break block24;
                    }
                    if (!NativeJavaObject.canConvert((Object)args[i], original_pcls)) return 0;
                    from = clsOrderMap.get(args[i].getClass());
                    Integer to = clsOrderMap.get(original_pcls);
                    ret = from != null && to != null && from <= to ? (ret += full_dd - clsOrderMap.size() + (to - from) - 1) : (ret += maybe_dd);
                }
                if (pcls.isAssignableFrom(argCls) && pcls == Object.class && argCls != Object.class) {
                    --ret;
                }
            }
            ++i;
        }
        return ret;
    }

    private static void jsToJava(Class<?>[] paramTypes, Object[] args) {
        if (args != null && args.length > 0) {
            int i = 0;
            for (Object arg : args) {
                args[i] = KJsType.js2java(arg, paramTypes[i]);
                ++i;
            }
        }
    }

    static {
        int order = 0;
        clsOrderMap.put(Boolean.TYPE, order);
        clsOrderMap.put(Boolean.class, order);
        clsOrderMap.put(Byte.TYPE, ++order);
        clsOrderMap.put(Byte.class, order);
        clsOrderMap.put(Character.TYPE, ++order);
        clsOrderMap.put(Character.class, order);
        clsOrderMap.put(Short.TYPE, ++order);
        clsOrderMap.put(Short.class, order);
        clsOrderMap.put(Integer.TYPE, ++order);
        clsOrderMap.put(Integer.class, order);
        clsOrderMap.put(Long.TYPE, ++order);
        clsOrderMap.put(Long.class, order);
        clsOrderMap.put(Float.TYPE, ++order);
        clsOrderMap.put(Float.class, order);
        clsOrderMap.put(Double.TYPE, ++order);
        clsOrderMap.put(Double.class, order);
        clsOrderMap.put(BigInteger.class, ++order);
        clsOrderMap.put(BigDecimal.class, ++order);
        max_d = BigDecimal.valueOf(Double.MAX_VALUE);
        min_d = BigDecimal.valueOf(Double.MIN_VALUE);
        max_long = BigDecimal.valueOf(Long.MAX_VALUE);
        min_long = BigDecimal.valueOf(Long.MIN_VALUE);
    }

    private static final class MatchResult {
        private int weight;
        private final Object[] args;
        private final Class<?>[] methodParameterTypes;

        MatchResult(int weight, Object[] args, Class<?>[] methodParameterTypes) {
            this.weight = weight;
            this.args = args;
            this.methodParameterTypes = methodParameterTypes;
        }
    }

    public static class MethodInfo {
        private Object obj;
        private Method method;
        private Object[] args;
        private Scriptable scope;

        private MethodInfo(Object obj, Method method, Object[] args, Scriptable scope) {
            this.obj = obj;
            this.method = method;
            this.args = args;
            this.scope = scope;
        }

        public Method getMethod() {
            return this.method;
        }

        public Callable<?> toCallable() {
            return () -> {
                try {
                    Class[] parameterTypes = this.method.getParameterTypes();
                    if (parameterTypes.length > 0) {
                        KRuntime.jsToJava(parameterTypes, this.args);
                        return KJsType.java2js(this.method.invoke(this.obj, this.args), this.scope);
                    }
                    return KJsType.java2js(this.method.invoke(this.obj, new Object[0]), this.scope);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            };
        }

        public Callable<?> toCallable(MethodHandle h, Class<?>[] paramTypes) {
            return () -> {
                try {
                    if (paramTypes.length > 0) {
                        KRuntime.jsToJava(paramTypes, this.args);
                        return KJsType.java2js(h.invoke(this.obj, this.args), this.scope);
                    }
                    return KJsType.java2js(h.invoke(this.obj), this.scope);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = ((InvocationTargetException)e).getTargetException();
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

