/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import kd.bos.script.ScriptException;
import kd.bos.script.debug.CallableWithInfo;
import kd.bos.script.debug.DebugThreadType;
import kd.bos.script.jsengine.debug.DebugIdThread;
import kd.bos.script.jsengine.debug.FutureCallable;
import kd.bos.script.jsengine.debug.KDebugLog;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.resource.Resources;

class AbstractDebugThread
implements AutoCloseable {
    private final String debugId;
    private final DebugThreadType threadType;
    private final boolean cmdType;
    private volatile boolean terminaled = false;
    private Thread debugThread;
    protected final LinkedList<FutureCallable<?>> taskList = new LinkedList();
    protected final Object taskListLock = new Object();
    protected volatile boolean busy = false;
    private Runnable runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new Runnable(){

        @Override
        public void run() {
            DebugIdThread.set(AbstractDebugThread.this.debugId, AbstractDebugThread.this.threadType);
            Thread.currentThread().setName(Resources.getString((String)"\u8c03\u8bd5", (String)"AbstractDebugThread_0", (String)"bos-serverscript", (Object[])new Object[0]) + (Object)((Object)AbstractDebugThread.this.threadType) + "-" + AbstractDebugThread.this.debugId);
            while (!AbstractDebugThread.this.terminaled) {
                try {
                    FutureTask<?> ft = this.pollFirstTask();
                    if (ft.isCancelled() || ft.isDone()) continue;
                    if (AbstractDebugThread.this.terminaled) {
                        ft.cancel(true);
                        break;
                    }
                    if (AbstractDebugThread.this.cmdType) {
                        KDebugLog.info((Object)((Object)AbstractDebugThread.this.threadType) + " runnable-run: " + ft);
                    } else {
                        KDebugLog.info("runnable-run: " + ft);
                    }
                    ft.run();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    AbstractDebugThread.this.busy = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FutureTask<?> pollFirstTask() throws InterruptedException {
            FutureTask ft;
            Object object = AbstractDebugThread.this.taskListLock;
            synchronized (object) {
                do {
                    if ((ft = (FutureTask)AbstractDebugThread.this.taskList.pollFirst()) != null) continue;
                    AbstractDebugThread.this.taskListLock.wait();
                } while (ft == null);
                AbstractDebugThread.this.busy = true;
            }
            return ft;
        }
    });

    protected AbstractDebugThread(String debugId, DebugThreadType threadType) {
        this.debugId = debugId;
        this.threadType = threadType;
        this.cmdType = threadType == DebugThreadType.cmd;
        this.start();
    }

    private void start() {
        this.debugThread = new Thread(DebugIdThread.debugThreadGroup, this.runnable);
        this.debugThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Future<T> submit(CallableWithInfo<T> callable, boolean inspect) throws ScriptException {
        try {
            this.checkTerminaled();
            FutureCallable<T> ft = new FutureCallable<T>(callable);
            if (this.callBySelfThread()) {
                if (this.cmdType) {
                    KDebugLog.info((Object)((Object)this.threadType) + " submit-run inspect=" + inspect + ": " + callable);
                } else {
                    KDebugLog.info("submit-run inspect=" + inspect + ": " + callable);
                }
                ft.run();
            } else {
                if (this.cmdType) {
                    KDebugLog.info((Object)((Object)this.threadType) + " submit-put inspect=" + inspect + ": " + callable);
                } else {
                    KDebugLog.info("submit-put inspect=" + inspect + ": " + callable);
                }
                Object object = this.taskListLock;
                synchronized (object) {
                    this.taskList.add(ft);
                    this.taskListLock.notifyAll();
                }
            }
            return ft;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    protected boolean callBySelfThread() {
        return Thread.currentThread() == this.debugThread;
    }

    protected void checkTerminaled() {
        if (this.terminaled) {
            throw new IllegalStateException(Thread.currentThread() + Resources.getString((String)"\u8c03\u8bd5\u7ebf\u7a0b\u5df2\u505c\u6b62\u3002", (String)"AbstractDebugThread_1", (String)"bos-serverscript", (Object[])new Object[0]));
        }
    }

    protected boolean isTerminaled() {
        return this.terminaled;
    }

    @Override
    public void close() throws ScriptException {
        try {
            if (this.debugThread != null) {
                KDebugLog.info((Object)((Object)this.threadType) + " close...");
                this.terminaled = true;
                this.debugThread.interrupt();
                DebugIdThread.remove(this.debugThread);
                this.debugThread = null;
            }
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }
}

