/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.script.ScriptException;
import kd.bos.script.debug.CallableWithInfo;
import kd.bos.script.debug.DebugThreadType;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.debug.AbstractDebugThread;
import kd.bos.script.jsengine.debug.KDebugLog;

public class DebugMainThread
extends AbstractDebugThread {
    private static final FutureTask<Object> nullFutureTask = new FutureTask<Object>(() -> null);
    private static final Object NULL = new Object();
    private final Object pauseLock = new Object();
    private final AtomicBoolean pausing = new AtomicBoolean();
    private CallableWithInfo<?> inspectCall;
    private BlockingQueue<Object> inspectCallResult = new ArrayBlockingQueue<Object>(1);

    public DebugMainThread(String debugId) {
        super(debugId, DebugThreadType.main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(CallableWithInfo<T> callable, boolean inspect) throws ScriptException {
        try {
            if (this.callBySelfThread() || !inspect) {
                return super.submit(callable, inspect);
            }
            while (this.busy) {
                if (this.pausing.get()) {
                    Object object = this.pauseLock;
                    synchronized (object) {
                        this.inspectCall = callable;
                        this.pauseLock.notifyAll();
                    }
                    Object ret = this.inspectCallResult.take();
                    if (ret == NULL) {
                        return nullFutureTask;
                    }
                    FutureTask<Object> f = new FutureTask<Object>(() -> {
                        if (ret instanceof Throwable) {
                            if (ret instanceof Exception) {
                                throw (Exception)ret;
                            }
                            throw new Exception((Throwable)ret);
                        }
                        return ret == null ? NULL : ret;
                    });
                    f.run();
                    return f;
                }
                Thread.sleep(10L);
            }
            return nullFutureTask;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws InterruptedException {
        KDebugLog.info("pause");
        do {
            Object object = this.pauseLock;
            synchronized (object) {
                this.pausing.set(true);
                this.pauseLock.wait(600000L);
                if (this.isTerminaled()) {
                    break;
                }
                if (this.inspectCall != null) {
                    this.inspect();
                }
            }
        } while (this.pausing.get());
        KDebugLog.info("pause-over");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        KDebugLog.info("resume");
        Object object = this.pauseLock;
        synchronized (object) {
            this.pausing.set(false);
            this.pauseLock.notifyAll();
        }
    }

    private void inspect() throws InterruptedException {
        KContext.get().maskDebug(true);
        Object ret = null;
        try {
            KDebugLog.info("inspect-call: " + this.inspectCall);
            ret = this.inspectCall.call();
        }
        catch (Exception e) {
            ret = e;
        }
        finally {
            KDebugLog.info("inspect-result: " + ret);
            this.inspectCall = null;
            KContext.get().maskDebug(false);
            if (ret == null) {
                ret = NULL;
            }
            this.inspectCallResult.put(ret);
        }
    }

    static {
        nullFutureTask.run();
    }
}

