/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptExecutorFactory;
import kd.bos.script.ScriptInfo;
import kd.bos.script.debug.CallableWithInfo;
import kd.bos.script.debug.DebugCache;
import kd.bos.script.debug.DebugConfig;
import kd.bos.script.debug.DebugExecutor;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.debug.DebugParameter;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.debug.DebugStepBack;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.KContextFactory;
import kd.bos.script.jsengine.KExecutor;
import kd.bos.script.jsengine.debug.DIM;
import kd.bos.script.jsengine.debug.DebugCmdThread;
import kd.bos.script.jsengine.debug.DebugMainThread;
import kd.bos.script.jsengine.debug.KBreakPoints;
import kd.bos.script.jsengine.debug.KDebugCache;
import kd.bos.script.jsengine.debug.KDebugExecutor;
import kd.bos.script.jsengine.debug.KDebugLog;
import kd.bos.script.jsengine.debug.KDebugUtil;
import kd.bos.script.jsengine.debug.KDebugger;
import kd.bos.script.jsengine.debug.KScopeProvider;
import kd.bos.script.jsengine.debug.QueueDebugCallBack;
import kd.bos.script.jsengine.objects.KConsoleObject;
import kd.bos.script.jsengine.objects.LogMessage;
import kd.bos.script.log.KScriptLogable;
import kd.bos.script.util.ScriptLookup;
import kd.bos.util.DisCardUtil;
import kd.bos.util.resource.Resources;
import org.mozilla.javascript.Scriptable;

public class KDebugManager
implements DebugManager,
KScriptLogable {
    private static final Object dmPutLock = new byte[0];
    private static final Map<String, DebugCache> cacheMap = new HashMap<String, DebugCache>();
    private static final LoadingCache<String, DebugManager> debuggerHolder = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterAccess(1200L, TimeUnit.SECONDS).initialCapacity(10).maximumSize(100L).recordStats().removalListener((RemovalListener)new RemovalListener<String, DebugManager>(){

        public void onRemoval(RemovalNotification<String, DebugManager> notification) {
            KDebugManager.clearDebugResource((KDebugManager)notification.getValue());
            KDebugLog.info("[DebugManager] " + (String)notification.getKey() + " was removed, cause is " + notification.getCause() + ".");
        }
    }).build((CacheLoader)new CacheLoader<String, DebugManager>(){

        public DebugManager load(String key) throws ScriptException {
            return null;
        }
    });
    private volatile boolean debugBooted = false;
    private String debugId;
    private KExecutor executor;
    private KDebugExecutor de;
    private DebugStepBack dcb;
    private DIM dim;
    private String curScriptName;
    private KBreakPoints breakPoints = new KBreakPoints();
    private Map<String, Set<String>> watchMap = new ConcurrentHashMap<String, Set<String>>();
    private boolean ignoreSystemScripts = false;
    private KDebugger debugCommander;
    private CountDownLatch cdCompleted = new CountDownLatch(1);
    private volatile boolean terminaled = false;
    private AtomicBoolean startupFlag = new AtomicBoolean(false);
    private AtomicBoolean skipAllBreakpointsFlag = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugManager waitForDebugManager(String debugId) throws InterruptedException {
        DebugConfig.checkDebugEnabled();
        DebugManager dm = null;
        long ts = System.currentTimeMillis();
        while (dm == null) {
            Object object = dmPutLock;
            synchronized (object) {
                dm = KDebugManager.getDebugManager(debugId);
                if (dm == null) {
                    dmPutLock.wait(600000L);
                }
            }
            if (dm != null || (dm = KDebugManager.getDebugManager(debugId)) != null || System.currentTimeMillis() - ts < 600000L) continue;
            throw new RuntimeException(Resources.getString((String)"cmd\u8c03\u8bd5\u7ebf\u7a0b\u7b49\u5f85main\u8bf7\u6c42\u7ebf\u7a0b\u8d85\u65f6\u3002(debugId=", (String)"KDebugManager_0", (String)"bos-serverscript", (Object[])new Object[0]) + debugId + ")");
        }
        return dm;
    }

    public static DebugManager getDebugManager(String debugId) {
        return (DebugManager)debuggerHolder.asMap().get(debugId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDebugManager(String debugId, DebugManager dm) {
        Object object = dmPutLock;
        synchronized (object) {
            debuggerHolder.asMap().put(debugId, dm);
            dmPutLock.notifyAll();
        }
        KDebugLog.info("[DebugManager] put debugId=" + debugId);
    }

    public static void removeDebugManager(String debugId) {
        debuggerHolder.asMap().remove(debugId);
        KDebugLog.info("[DebugManager] remove debugId=" + debugId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAtDebugMainThread(String debugId, CallableWithInfo<T> callable, boolean inspect) throws ScriptException {
        DebugCache cache = KDebugManager.getDebugCache(debugId);
        String key = "_inner_debug_main_thread";
        DebugMainThread dt = (DebugMainThread)cache.get(key);
        if (dt == null) {
            DebugCache debugCache = cache;
            synchronized (debugCache) {
                dt = (DebugMainThread)cache.get(key);
                if (dt == null) {
                    dt = new DebugMainThread(debugId);
                    cache.set(key, dt);
                }
            }
        }
        try {
            return dt.submit(callable, inspect).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ScriptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runAtDebugCmdThread(String debugId, CallableWithInfo<T> callable) throws ScriptException {
        DebugCache cache = KDebugManager.getDebugCache(debugId);
        String key = "_inner_debug_cmd_thread";
        DebugCmdThread dt = (DebugCmdThread)cache.get(key);
        if (dt == null) {
            DebugCache debugCache = cache;
            synchronized (debugCache) {
                dt = (DebugCmdThread)cache.get(key);
                if (dt == null) {
                    dt = new DebugCmdThread(debugId);
                    cache.set(key, dt);
                }
            }
        }
        try {
            return (T)dt.submit((CallableWithInfo)callable, false).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ScriptException(e);
        }
    }

    public static DebugMainThread getDebugMainThread(String debugId) {
        return (DebugMainThread)KDebugManager.getDebugCache(debugId).get("_inner_debug_main_thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugCache getDebugCache(String debugId) {
        DebugCache dc = cacheMap.get(debugId);
        if (dc == null) {
            Map<String, DebugCache> map = cacheMap;
            synchronized (map) {
                dc = cacheMap.get(debugId);
                if (dc == null) {
                    dc = new KDebugCache();
                    cacheMap.put(debugId, dc);
                }
            }
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DebugStepBack getOrCreateDebugStepBack(String debugId) {
        DebugCache cache = KDebugManager.getDebugCache(debugId);
        String key = "_inner_debug_step_back";
        DebugStepBack ret = (DebugStepBack)cache.get(key);
        if (ret == null) {
            DebugCache debugCache = cache;
            synchronized (debugCache) {
                ret = (DebugStepBack)cache.get(key);
                if (ret == null) {
                    ret = new QueueDebugCallBack();
                    cache.set(key, ret);
                }
            }
        }
        return ret;
    }

    private static void clearDebugResource(KDebugManager dm) {
        if (dm != null) {
            DebugCache dc = cacheMap.remove(dm.debugId);
            if (dc != null) {
                try {
                    dc.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (dm.debugCommander != null) {
                dm.debugCommander.clearDebug();
            }
            ScriptExecutorFactory.removeScriptExecutorByDebug(dm.debugId);
        }
    }

    public KDebugManager(String debugId, final KExecutor executor) {
        if (debugId == null || debugId.length() == 0) {
            debugId = UUID.randomUUID().toString();
        }
        this.debugId = debugId;
        this.executor = executor;
        this.dcb = KDebugManager.getOrCreateDebugStepBack(debugId);
        KDebugLog.info("attach debug");
        this.dim = new DIM(this.skipAllBreakpointsFlag);
        this.dim.attachTo(KContextFactory.getGlobal());
        this.dim.setScopeProvider(new KScopeProvider(){

            @Override
            public Scriptable getScope() {
                return ((KContext)executor.getContext()).getScope();
            }
        });
        KDebugManager.setDebugManager(debugId, this);
    }

    public synchronized void bootDebug(ScriptInfo scriptInfo, ScriptLookup scriptLookup) {
        if (this.debugBooted) {
            throw new IllegalStateException(Resources.getString((String)"\u5df2\u542f\u52a8\u8c03\u8bd5\u6a21\u5f0f\uff0c\u4e0d\u53ef\u91cd\u590d\u542f\u52a8\u3002", (String)"KDebugManager_1", (String)"bos-serverscript", (Object[])new Object[0]));
        }
        this.debugBooted = true;
        this.de = new KDebugExecutor(this.debugId, scriptLookup, this.dcb);
        this.curScriptName = scriptInfo.getName();
        DebugParameter debugParam = new DebugParameter();
        this.watchMap.putIfAbsent(scriptInfo.getName(), new HashSet());
        Set<String> watches = this.watchMap.get(scriptInfo.getName());
        this.de.start(this, null, scriptInfo, debugParam, watches.toArray(new String[watches.size()]), this.ignoreSystemScripts, this.executor, () -> this.terminal());
        if (!this.ignoreSystemScripts) {
            this.ignoreSystemScripts = true;
        }
    }

    public void resetForNextExecute() {
        this.terminaled = false;
        this.cdCompleted = new CountDownLatch(1);
    }

    @Override
    public DebugExecutor getDebugExecutor() {
        return this.de;
    }

    DebugResult takeDebugResult(boolean waitFor) {
        DebugResult ret = this.dcb.peek();
        if (ret == null && !waitFor) {
            return null;
        }
        while (ret == null) {
            try {
                ret = this.dcb.poll(50L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                DisCardUtil.discard();
            }
            if (!this.terminaled) continue;
            return ret;
        }
        boolean isRunning = ret.isRunning();
        if (isRunning) {
            return ret;
        }
        DebugResult next = null;
        while (true) {
            if ((next = this.dcb.peek()) != null) {
                this.dcb.take();
                if (!next.isRunning()) continue;
                ret = next;
                break;
            }
            if (this.terminaled) break;
            this.trySleepAndIgnoredException(100L);
        }
        return ret;
    }

    private void trySleepAndIgnoredException(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public DIM getDIM() {
        return this.dim;
    }

    @Override
    public void addBreakPoint(String scriptName, int ... breakPointLines) {
        this.breakPoints.addBreakPoint(scriptName, breakPointLines);
    }

    @Override
    public void removeBreakPoint(String scriptName, int ... breakPointLines) {
        this.breakPoints.removeBreakPoint(scriptName, breakPointLines);
    }

    @Override
    public void setBreakPoint(String scriptName, int ... breakPointLines) {
        this.breakPoints.setBreakPoint(scriptName, breakPointLines);
    }

    @Override
    public void clearBreakPoints(String scriptName) {
        this.breakPoints.clearBreakPoints(scriptName);
    }

    @Override
    public void clearAllBreakPoints() {
        this.breakPoints.clearAllBreakPoints();
    }

    public void setSkipAllBreakpoints(boolean skip) {
        this.skipAllBreakpointsFlag.set(skip);
    }

    @Override
    public void skipAllBreakpoints(boolean skip) {
        this.skipAllBreakpointsFlag.set(skip);
    }

    @Override
    public void addWatch(String scriptName, String expression) {
        this.watchMap.putIfAbsent(scriptName, new HashSet());
        this.watchMap.get(scriptName).add(expression);
        if (this.de != null && scriptName.equals(this.curScriptName)) {
            this.de.addWatch(expression);
        }
    }

    @Override
    public void removeWatch(String scriptName, String expression) {
        Set<String> set = this.watchMap.get(scriptName);
        if (set != null) {
            set.remove(expression);
        }
        if (this.de != null && scriptName.equals(this.curScriptName)) {
            this.de.removeWatch(expression);
        }
    }

    @Override
    public void clearWatches(String scriptName) {
        this.watchMap.remove(scriptName);
        if (this.de != null && scriptName.equals(this.curScriptName)) {
            this.de.clearWatches();
        }
    }

    @Override
    public void clearAllWatches() {
        this.watchMap.clear();
        if (this.de != null) {
            this.de.clearWatches();
        }
    }

    public void setDebugCommander(KDebugger debugger) {
        this.debugCommander = debugger;
    }

    @Override
    public ScriptExecutor getScriptExecutor() {
        return this.executor;
    }

    public boolean isDebugBooted() {
        return this.debugBooted;
    }

    @Override
    public void start() {
        this.startupFlag.set(true);
        this.executor.debugStepStart(false);
    }

    @Override
    public void startup() {
        this.startupFlag.set(true);
        this.executor.debugStepStart(true);
    }

    @Override
    public void updateScriptInfo(final ScriptInfo ... scriptInfos) {
        Callable<Object> execScript = new Callable<Object>(){

            @Override
            public Object call() throws ScriptException {
                try {
                    KDebugManager.this.executor.exec(scriptInfos);
                }
                catch (Exception e) {
                    if (e instanceof ScriptException) {
                        throw e;
                    }
                    throw new ScriptException(e);
                }
                return null;
            }
        };
        try {
            DebugManager.runAtDebugMainThread(this.debugId, execScript, () -> "re-evaluate script content");
        }
        catch (Exception e) {
            KDebugUtil.handleException(e);
        }
    }

    @Override
    public DebugResult startupThenGet() {
        this.startup();
        if (this.de == null) {
            DebugResult result = new DebugResult();
            result.setDebugId(this.debugId);
            return result;
        }
        return this.de.getAtBreakPoint(true);
    }

    public void stopped() {
        this.cdCompleted.countDown();
    }

    public void waitForStop() {
        try {
            this.cdCompleted.await(KContext.get().getDebugTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
    }

    @Override
    public boolean isTerminaled() {
        return this.terminaled;
    }

    public void terminal() {
        this.terminaled = true;
    }

    @Override
    public boolean isStarted() {
        return this.startupFlag.get();
    }

    public DIM.SourceInfo getCurrentSourceInfo() {
        return this.debugCommander == null ? null : this.debugCommander.getCurrentSourceInfo();
    }

    public KBreakPoints getBreakPoints() {
        return this.breakPoints;
    }

    @Override
    public List<LogMessage> getLogMessages() {
        KConsoleObject console = (KConsoleObject)this.executor.getContext().get("console");
        return console.getLogMessages();
    }
}

