/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptFunction;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.jsengine.debug.DIM;
import kd.bos.script.jsengine.debug.KClassUtils;
import kd.bos.script.jsengine.debug.KDebugVarFilter;
import kd.bos.script.jsengine.debug.KDebugger;
import kd.bos.script.jsengine.debug.KStackFrame;
import kd.bos.script.jsengine.def.typemap.KJsType;
import kd.bos.script.log.KScriptLogable;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

class KDebugVars
implements KScriptLogable {
    private static final String NOT_AVAILABLE = "(not available)";
    private static final String UNDEFINED = "undefined";
    private static final String NULL = "null";
    private static final String ERROR_PREFIX = "[error] ";

    KDebugVars() {
    }

    static DebugResult buildAll(KDebugger debugger, KStackFrame kframe) {
        return KDebugVars.build(debugger, kframe, true, true);
    }

    static DebugResult buildNone(KDebugger debugger, KStackFrame kframe) {
        return KDebugVars.build(debugger, kframe, false, false);
    }

    static DebugResult buildVariables(KDebugger debugger, KStackFrame kframe) {
        return KDebugVars.build(debugger, kframe, true, false);
    }

    static DebugResult buildWatches(KDebugger debugger, KStackFrame kframe) {
        return KDebugVars.build(debugger, kframe, false, true);
    }

    private static DebugResult build(KDebugger debugger, KStackFrame kframe, boolean variables, boolean watches) {
        DebugResult result = new DebugResult();
        result.setDebugId(debugger.getDebugId());
        if (kframe == null) {
            result.setRunning(false);
            result.setSuccess(true);
            result.setCurrentLine(-1);
            return result;
        }
        result.setRunning(true);
        result.setSuccess(true);
        if (variables) {
            KDebugVars.appendVariables(result, kframe, debugger);
        }
        if (watches) {
            KDebugVars.appendWatches(result, kframe, debugger, new HashSet<String>());
        }
        return result;
    }

    private static void appendVariables(DebugResult result, KStackFrame kframe, final KDebugger debugger) {
        final DIM.StackFrame frame = kframe.getDebugFrame();
        if (frame != null) {
            result.setCurrentLine(frame.getBreakPointLineNumber());
            final HashMap<String, Object> map = new HashMap<String, Object>();
            result.setVariables(map);
            debugger.getDebugExecutor().inspect(new Callable<Object>(){

                @Override
                public Object call() throws ScriptException {
                    try {
                        Set<ScriptClassInfo> definedClassSet = debugger.getScriptExecutor().getContext().getAllDefinedClasses();
                        HashSet<String> nameSet = new HashSet<String>(definedClassSet.size());
                        for (ScriptClassInfo cls : definedClassSet) {
                            nameSet.add(cls.getName());
                        }
                        Object thisObj = frame.thisObj();
                        HashMap<String, String> thisMap = new HashMap<String, String>();
                        map.put("this", thisMap);
                        thisMap.put("$$type", thisObj.getClass().getSimpleName());
                        KDebugVars.appendVariable(debugger, thisObj, debugger.getDim().getObjectIds(thisObj), thisMap, true, nameSet);
                        Object local = frame.scope();
                        if (local == thisObj) {
                            map.put("local", thisMap);
                        } else {
                            HashMap<String, String> localMap = new HashMap<String, String>();
                            map.put("local", localMap);
                            localMap.put("$$type", local.getClass().getSimpleName());
                            KDebugVars.appendVariable(debugger, local, debugger.getDim().getObjectIds(local), localMap, false, nameSet);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new ScriptException(e);
                    }
                }
            }, () -> "inspect variables");
        }
    }

    private static void appendVariable(KDebugger debugger, Object scope, Object[] objectIds, Map<String, Object> map, boolean isThisObj, Set<String> definedClassSet) {
        String key = null;
        for (int i = 0; i < objectIds.length; ++i) {
            Object value;
            key = String.valueOf(objectIds[i]);
            if (!KDebugVarFilter.publishedId(key, isThisObj) || !KDebugVarFilter.publishedIdValue(key, value = debugger.getDim().getObjectProperty(scope, key), isThisObj, definedClassSet)) continue;
            if (value == null) {
                value = NULL;
            } else if (value instanceof Undefined) {
                value = UNDEFINED;
            } else {
                try {
                    if (KDebugVars.resolveObject(debugger, key, value, map, definedClassSet, new HashSet<Object>())) continue;
                    value = debugger.getDim().objectToString(value);
                }
                catch (Exception t) {
                    value = ERROR_PREFIX + t.getMessage();
                }
            }
            map.put(key, value);
        }
    }

    private static boolean resolveObject(KDebugger debugger, String key, Object value, Map<String, Object> map, Set<String> definedClassSet, Set<Object> resolvedSet) {
        if (value == null || value == Undefined.instance) {
            return false;
        }
        if ((value = KJsType.js2java(value)) instanceof ScriptFunction) {
            value = ((ScriptFunction)value).getNativeFunction();
        }
        if (resolvedSet.contains(value)) {
            return true;
        }
        resolvedSet.add(value);
        Class<?> valueCls = value.getClass();
        if (KClassUtils.isPrimitiveOrWrapper(valueCls) || KClassUtils.isPrimitiveWrapperArray(valueCls) || Enum.class.isAssignableFrom(valueCls) || String.class.isAssignableFrom(valueCls)) {
            return false;
        }
        if (value instanceof BaseFunction) {
            KDebugVars.resolveObjectBaseFunction(key, value, map);
        } else if (value.getClass().isArray()) {
            KDebugVars.resolveObjectArray(debugger, key, value, map, definedClassSet, resolvedSet);
        } else if (value instanceof NativeArray) {
            KDebugVars.resolveObjectNativeArray(debugger, key, value, map, definedClassSet, resolvedSet);
        } else if (value instanceof Scriptable) {
            KDebugVars.resolveObjectScriptable(debugger, key, value, map, definedClassSet, valueCls);
        } else {
            KDebugVars.resolveObjectDefault(debugger, key, value, map, definedClassSet, valueCls, resolvedSet);
        }
        return true;
    }

    private static void resolveObjectBaseFunction(String key, Object value, Map<String, Object> map) {
        BaseFunction nf = (BaseFunction)value;
        String funcName = nf.getFunctionName();
        String toString = nf.getTypeOf() + (funcName.length() == 0 ? "" : " ") + funcName + "()";
        map.put(key, toString);
    }

    private static void resolveObjectArray(KDebugger debugger, String key, Object value, Map<String, Object> map, Set<String> definedClassSet, Set<Object> resolvedSet) {
        int n = Array.getLength(value);
        ArrayList<Object> list = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> valueMap;
            Object arrayValue = Array.get(value, i);
            if (KDebugVars.resolveObject(debugger, "V", arrayValue, valueMap = new HashMap<String, Object>(), definedClassSet, resolvedSet)) {
                list.add(valueMap.get("V"));
                continue;
            }
            list.add(KJsType.js2java(arrayValue));
        }
        map.put(key, list);
    }

    private static void resolveObjectNativeArray(KDebugger debugger, String key, Object value, Map<String, Object> map, Set<String> definedClassSet, Set<Object> resolvedSet) {
        NativeArray array = (NativeArray)value;
        ArrayList<Object> list = new ArrayList<Object>(array.size());
        for (Object i : array.getIds()) {
            HashMap<String, Object> valueMap;
            Object arrayValue = array.get(i);
            if (KDebugVars.resolveObject(debugger, "V", arrayValue, valueMap = new HashMap<String, Object>(), definedClassSet, resolvedSet)) {
                list.add(valueMap.get("V"));
                continue;
            }
            list.add(KJsType.js2java(arrayValue));
        }
        map.put(key, list);
    }

    private static void resolveObjectScriptable(KDebugger debugger, String key, Object value, Map<String, Object> map, Set<String> definedClassSet, Class<?> valueCls) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        map.put(key, newMap);
        newMap.put("$$type", valueCls.getSimpleName());
        KDebugVars.appendVariable(debugger, value, debugger.getDim().getObjectIds(value), newMap, false, definedClassSet);
    }

    private static void resolveObjectDefault(KDebugger debugger, String key, Object value, Map<String, Object> map, Set<String> definedClassSet, Class<?> valueCls, Set<Object> resolvedSet) {
        if (!KJsType.isKSObjectType(valueCls)) {
            map.put(key, debugger.getDim().objectToString(value));
            return;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>(8);
        map.put(key, newMap);
        newMap.put("$$type", valueCls.getSimpleName());
        for (Method method : valueCls.getMethods()) {
            boolean condition;
            String name = method.getName();
            boolean bl = condition = KJsType.isKSObjectMethod(method) && method.getReturnType() != Void.class && (name.startsWith("get") || name.startsWith("is")) && !"getClass".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0;
            if (!condition) {
                return;
            }
            int i = name.startsWith("get") ? 3 : 2;
            String prop = name.substring(i);
            prop = name.equals("get") || name.equals("is") ? name : Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
            Object getValue = null;
            try {
                getValue = method.invoke(value, new Object[0]);
                if (getValue == value) continue;
                if (getValue != null) {
                    if (KDebugVars.resolveObject(debugger, prop, getValue, newMap, definedClassSet, resolvedSet)) continue;
                    getValue = debugger.getDim().objectToString(getValue);
                }
            }
            catch (Exception t) {
                getValue = ERROR_PREFIX + t.getMessage();
            }
            newMap.put(prop, getValue);
        }
    }

    private static void appendWatches(DebugResult result, KStackFrame kframe, final KDebugger debugger, final Set<String> definedClassSet) {
        final Set<String> watches = debugger.getWatches();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        result.setWatches(map);
        final DIM.StackFrame frame = kframe.getDebugFrame();
        if (frame != null) {
            result.setCurrentLine(frame.getBreakPointLineNumber());
            debugger.getDebugExecutor().inspect(new Callable<Object>(){

                @Override
                public Object call() throws ScriptException {
                    try {
                        Object scope = frame.scope();
                        ImmutableList objectIds = ImmutableList.copyOf((Object[])debugger.getDim().getObjectIds(scope));
                        String key2 = null;
                        for (String key2 : watches) {
                            Object value = null;
                            if (objectIds.contains(key2)) {
                                value = debugger.getDim().getObjectProperty(scope, key2);
                            } else {
                                try {
                                    value = debugger.getDim().eval(key2, true);
                                }
                                catch (Exception e) {
                                    KScriptLogable.log.warn(e.getMessage(), (Throwable)e);
                                    value = KDebugVars.NOT_AVAILABLE;
                                }
                            }
                            if (value == null) {
                                value = KDebugVars.NULL;
                            } else if (value instanceof Undefined) {
                                value = KDebugVars.UNDEFINED;
                            } else {
                                try {
                                    if (KDebugVars.resolveObject(debugger, key2, value, map, definedClassSet, new HashSet())) continue;
                                    value = debugger.getDim().objectToString(value);
                                }
                                catch (Exception t) {
                                    value = KDebugVars.ERROR_PREFIX + t.getMessage();
                                    KScriptLogable.log.warn(String.valueOf(value), (Throwable)t);
                                }
                            }
                            map.put(key2, String.valueOf(value));
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new ScriptException(e);
                    }
                }
            }, () -> "inspect watches");
        } else {
            for (String exp : watches) {
                map.put(exp, NOT_AVAILABLE);
            }
        }
    }

    static Object resolveEvaluate(String expression, KDebugger debugger) {
        return debugger.getDebugExecutor().inspect(() -> {
            Object ret = debugger.getDim().eval(expression, true);
            Set<ScriptClassInfo> definedClassSet = debugger.getScriptExecutor().getContext().getAllDefinedClasses();
            HashSet<String> nameSet = new HashSet<String>(definedClassSet.size());
            for (ScriptClassInfo cls : definedClassSet) {
                nameSet.add(cls.getName());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (KDebugVars.resolveObject(debugger, "V", ret, map, nameSet, new HashSet<Object>())) {
                return map.get("V");
            }
            return KJsType.js2java(ret);
        }, () -> "evaluate " + expression);
    }
}

