/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.debug;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.debug.DebugExecutor;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.debug.DebugParameter;
import kd.bos.script.debug.DebugResult;
import kd.bos.script.jsengine.KExecutor;
import kd.bos.script.jsengine.KExecutorListener;
import kd.bos.script.jsengine.debug.DIM;
import kd.bos.script.jsengine.debug.GuiCallback;
import kd.bos.script.jsengine.debug.KBreakPoints;
import kd.bos.script.jsengine.debug.KDebugLog;
import kd.bos.script.jsengine.debug.KDebugManager;
import kd.bos.script.jsengine.debug.KDebugTerminalHandler;
import kd.bos.script.jsengine.debug.KRunToLine;
import kd.bos.script.jsengine.debug.KStackFrame;
import kd.bos.util.StringUtils;

final class KDebugger
implements GuiCallback {
    private KDebugManager dm;
    private DebugExecutor debugExecutor;
    private String debugId;
    private DIM dim;
    private KDebugTerminalHandler terminalHandler;
    private DebugParameter debugParam;
    private ScriptExecutor executor;
    private final Object sourceInfoLock = new Object();
    private volatile DIM.SourceInfo sourceInfo;
    private int maxBreakpointLine = Integer.MIN_VALUE;
    private Set<String> watches;
    private volatile KStackFrame step;
    private Object stepLock = new Object();
    private Thread attachedThread;
    private Thread cmdThread;
    private KRunToLine runTo = null;
    private CountDownLatch cdStop = new CountDownLatch(1);
    private volatile boolean stopped = false;
    private KExecutorListener stopListener = new KExecutorListener(){

        @Override
        public void onStop() {
        }

        @Override
        public void onEndContext() {
            this.doStop();
        }

        private void doStop() {
            KDebugger.this.cdStop.countDown();
            KDebugger.this.cmdStop();
        }
    };

    public KDebugger(String debugId, DebugParameter debugParam, String[] watches, KDebugManager dm, KDebugTerminalHandler terminalHandler) {
        this.dm = dm;
        this.debugExecutor = dm.getDebugExecutor();
        this.debugParam = debugParam;
        this.executor = dm.getScriptExecutor();
        this.terminalHandler = terminalHandler;
        this.debugId = StringUtils.isBlank((String)debugId) ? UUID.randomUUID().toString() : debugId;
        this.dim = dm.getDIM();
        if (watches != null) {
            this.setWatch(watches);
        }
        this.dim.setGuiCallback(this);
        dm.setDebugCommander(this);
        this.attachedThread = Thread.currentThread();
    }

    public DebugManager getDebugManager() {
        return this.dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugResult executeCmd(String cmdDesc, Runnable debugCmd) {
        this.cmdThread = Thread.currentThread();
        KDebugLog.info("execute cmd=" + cmdDesc);
        if (debugCmd != null) {
            debugCmd.run();
        }
        while (this.step == null) {
            Object object = this.stepLock;
            synchronized (object) {
                try {
                    this.stepLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.step.getDebugResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterInterrupt(DIM.StackFrame lastFrame, String threadTitle, String alertMessage) {
        boolean condition;
        int line = lastFrame.getLineNumber();
        boolean bl = condition = this.runTo != null && line != this.runTo.getLineNo();
        if (!condition) {
            lastFrame.setBreakPointLineNumber(line);
            Object object = this.stepLock;
            synchronized (object) {
                this.step = new KStackFrame(lastFrame, this);
                this.stepLock.notifyAll();
            }
            this.step.pause();
        }
    }

    public KStackFrame getStackFrame() {
        return this.step;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStep() {
        Object object = this.stepLock;
        synchronized (object) {
            this.step = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeStep() {
        Object object = this.stepLock;
        synchronized (object) {
            if (this.step != null) {
                this.step.resume();
            }
        }
    }

    @Override
    public void onResumed() {
    }

    public void enableBreak(boolean enableBreak) {
        if (enableBreak) {
            ((KExecutor)this.executor).addExecutorListener(this.stopListener);
        } else {
            ((KExecutor)this.executor).removeExecutorListener(this.stopListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRegist(DIM.SourceInfo sourceInfo) {
        Object object = this.sourceInfoLock;
        synchronized (object) {
            this.setCurrentSourceInfo(sourceInfo);
            this.sourceInfoLock.notify();
        }
    }

    public void setCurrentSourceInfo(DIM.SourceInfo sourceInfo) {
        if (this.sourceInfo != sourceInfo) {
            this.sourceInfo = sourceInfo;
            this.syncBreakPoints();
        }
    }

    private void syncBreakPoints() {
        KBreakPoints breakPoints = this.dm.getBreakPoints();
        String scriptName = this.sourceInfo.url();
        KDebugLog.info("setBreakPoints to " + scriptName);
        breakPoints.setupExecutingBreakPoints(scriptName, this.sourceInfo.getBreakpoints());
        if (this.debugParam != null) {
            this.setBreakOnEnter(this.debugParam.isBreakOnEnter());
            this.setBreakOnExceptions(this.debugParam.isBreakOnException());
            this.setBreakOnReturn(this.debugParam.isBreakOnReturn());
        }
    }

    private void setBreakOnEnter(boolean breakOnEnter) {
        this.dim.setBreakOnEnter(breakOnEnter);
    }

    private void setBreakOnExceptions(boolean breakOnExceptions) {
        this.dim.setBreakOnExceptions(breakOnExceptions);
    }

    public void setBreakOnReturn(boolean breakOnReturn) {
        this.dim.setBreakOnReturn(breakOnReturn);
    }

    private void resetMaxBreakPointLine() {
        this.maxBreakpointLine = this.sourceInfo.calcMaxBreakpointLine();
    }

    private void setMaxBreakPointLine(int maxBreakpointLine) {
        if (maxBreakpointLine > this.maxBreakpointLine) {
            this.maxBreakpointLine = maxBreakpointLine;
        }
    }

    public void addBreakPoint(int line) {
        if (this.sourceInfo.breakableLine(line)) {
            KDebugLog.info("addBreakPoint: " + line);
            boolean changed = this.sourceInfo.breakpoint(line, true);
            if (changed) {
                this.setMaxBreakPointLine(line);
            }
        }
    }

    public void setBreakPoint(int[] breakPointLines) {
        KDebugLog.info("setBreakPoint: " + Arrays.toString(breakPointLines));
        this.sourceInfo.removeAllBreakpoints();
        for (int line : breakPointLines) {
            boolean changed;
            if (!this.sourceInfo.breakableLine(line) || !(changed = this.sourceInfo.breakpoint(line, true))) continue;
            this.setMaxBreakPointLine(line);
        }
    }

    public void removeBreakPoint(int line) {
        if (this.sourceInfo.breakableLine(line)) {
            KDebugLog.info("removeBreakPoint line=" + line);
            boolean changed = this.sourceInfo.breakpoint(line, false);
            if (changed) {
                this.resetMaxBreakPointLine();
            }
        }
    }

    public void clearBreakPoint() {
        KDebugLog.info("clearBreakPoint");
        this.sourceInfo.removeAllBreakpoints();
    }

    public ScriptExecutor getScriptExecutor() {
        return this.executor;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public DIM getDim() {
        return this.dim;
    }

    public Set<String> getWatches() {
        return this.watches == null ? (this.watches = new LinkedHashSet<String>(1)) : this.watches;
    }

    public void addWatch(String ... expressiones) {
        List<String> list = Arrays.asList(expressiones);
        KDebugLog.info("addWatch: " + list);
        this.getWatches().addAll(list);
    }

    public void setWatch(String ... expressiones) {
        List<String> list = Arrays.asList(expressiones);
        KDebugLog.info("setWatch: " + list);
        Set<String> ss = this.getWatches();
        ss.clear();
        ss.addAll(list);
    }

    public boolean removeWatch(String ... expressiones) {
        List<String> list = Arrays.asList(expressiones);
        KDebugLog.info("removeWatch: " + list);
        if (this.watches == null) {
            return true;
        }
        return this.watches.removeAll(list);
    }

    public void clearWatches() {
        KDebugLog.info("clearWatches ");
        if (this.watches != null) {
            this.watches.clear();
        }
    }

    public DebugExecutor getDebugExecutor() {
        return this.debugExecutor;
    }

    @Override
    public boolean isGuiEventThread() {
        return false;
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdStart() {
        while (this.sourceInfo == null) {
            Object object = this.sourceInfoLock;
            synchronized (object) {
                try {
                    this.sourceInfoLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void cmdStepOver() {
        this.resumeStep();
        int returnValue = 0;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdStepInto() {
        this.resumeStep();
        int returnValue = 1;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdStepOut() {
        this.resumeStep();
        int returnValue = 2;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdRunToLine(final int lineNo) {
        this.resumeStep();
        final boolean changed = this.sourceInfo.breakpoint(lineNo, true);
        this.runTo = new KRunToLine(lineNo, new KRunToLine.Reset(){

            @Override
            public void reset() {
                KDebugger.this.runTo = null;
                if (changed) {
                    KDebugger.this.sourceInfo.breakpoint(lineNo, false);
                }
            }
        });
        int returnValue = 3;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdResume() {
        this.resumeStep();
        int returnValue = 6;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdGo() {
        this.resumeStep();
        int returnValue = 3;
        this.dim.setReturnValue(returnValue);
    }

    public void cmdStop() {
        this.stop(false);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop(boolean exist) {
        this.stopped = true;
        this.cdStop.countDown();
        KDebugLog.info("stopping..., exist=" + exist);
        int returnValue = 5;
        this.dim.setReturnValue(returnValue);
        this.resumeStep();
        this.onResumed();
        KDebugLog.info("stopped, exist=" + exist);
    }

    public void clearDebug() {
        this.stop(true);
        this.clearDebugListener();
        this.dim.dispose();
        this.terminalHandler.terminaled();
    }

    public void clearDebugListener() {
        ((KExecutor)this.executor).removeExecutorListener(this.stopListener);
    }

    public DIM.SourceInfo getCurrentSourceInfo() {
        return this.sourceInfo;
    }

    public Thread getAttachedThread() {
        return this.attachedThread;
    }

    public Thread getCmdThread() {
        return this.cmdThread;
    }
}

