/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.script.ScriptException;
import kd.bos.script.ScriptObject;
import kd.bos.script.ScriptTracker;
import kd.bos.script.ScriptWrapper;
import kd.bos.script.jsengine.KContext;
import kd.bos.script.jsengine.def.KDyTypeCache;
import kd.bos.script.jsengine.def.KDyWrapperFunctionCaller;
import kd.bos.script.jsengine.def.KObject;
import kd.bos.script.jsengine.def.PrototypeIdMap;
import kd.bos.script.jsengine.def.typemap.KJsType;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;

public class KDyWrapper
extends KObject
implements ScriptWrapper<Object> {
    private static final long serialVersionUID = -5584034927832842215L;
    protected static final Object ALREADY_CREATED_TAG = new Object();
    private final PrototypeIdMap idMap;
    private final KDyWrapperFunctionCaller functionCaller;
    private final String className;
    private Class<?> beanCls;
    protected Object beanObj;

    public static KDyWrapper createJavaDyWrapper(Class<? extends KDyWrapper> dyWrapperSubCls, Object beanObject, Class<?> beanCls) throws ScriptException {
        try {
            return dyWrapperSubCls.getConstructor(Object.class, Class.class).newInstance(beanObject, beanCls);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ScriptException(e);
        }
    }

    public static ScriptObject createJsDyWrapper(Object value) throws ScriptException {
        try {
            return KContext.get().createObject(value.getClass(), ALREADY_CREATED_TAG, value);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @JSConstructor
    public KDyWrapper() {
        this(null, null);
    }

    public KDyWrapper(Object beanObj, Class<?> beanCls) {
        this.beanObj = beanObj;
        this.idMap = KDyTypeCache.getDyClsIdMap().get(this.getClass());
        this.functionCaller = KDyTypeCache.getDyClsFunctionCallerMap().get(this.getClass());
        this.beanCls = beanCls == null ? this.getNativeClass() : beanCls;
        this.className = KJsType.getJSTypeName(this.beanCls);
    }

    protected void fillConstructorProperties(IdFunctionObject ctor) {
        super.fillConstructorProperties(ctor);
        ctor.setParentScope(this.getParentScope());
    }

    public Class<?> getNativeClass() {
        return this.beanCls;
    }

    @Override
    public String getClassName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        PrototypeIdMap.ID id = this.idMap.get(f.methodId());
        if (id != null) {
            return this.functionCaller.call(id.name, cx, scope, thisObj, args);
        }
        throw new IllegalArgumentException(f.getFunctionName());
    }

    protected void initPrototypeId(int id) {
        PrototypeIdMap.ID ID2 = this.idMap.get(id);
        if (ID2 == null) {
            throw new IllegalArgumentException(String.valueOf(id));
        }
        this.initPrototypeMethod(this.className, id, ID2.name, ID2.arity);
    }

    protected int findPrototypeId(String s) {
        PrototypeIdMap.ID id = this.idMap.get(s);
        if (id == null) {
            return 0;
        }
        return id.value;
    }

    @Override
    public Object unwrap() {
        Object unWrapObj;
        Object obj = this.beanObj;
        while ((obj instanceof Wrapper || obj instanceof ScriptWrapper) && (unWrapObj = obj instanceof Wrapper ? ((Wrapper)obj).unwrap() : ((ScriptWrapper)obj).unwrap()) != obj) {
            obj = unWrapObj;
        }
        return obj;
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return this.unwrap();
    }

    @Override
    public void __release() {
        if (this.beanObj instanceof ScriptObject) {
            ((ScriptObject)this.beanObj).__release();
            ScriptTracker.track("release " + this.beanObj);
            this.beanObj = null;
        }
        super.__release();
    }

    public Map<String, List<Method>> __getFunctionMap() {
        return new HashMap<String, List<Method>>(this.functionCaller.getFunctionMap());
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public Object get(int index, Scriptable start) {
        PrototypeIdMap.ID id;
        Object obj = super.get(index, start);
        if (obj == Scriptable.NOT_FOUND && (id = this.idMap.get(index)) != null) {
            return this.get(id.name, start);
        }
        return obj;
    }

    public Object get(String name, Scriptable start) {
        Callable callable;
        Object obj = super.get(name, start);
        if (obj == Scriptable.NOT_FOUND && (callable = this.functionCaller.getCallable(name)) != null) {
            return callable;
        }
        return obj;
    }

    public boolean has(int index, Scriptable start) {
        return this.idMap.get(index) != null || super.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        return this.functionCaller.getFunctionMap().containsKey(name) || super.has(name, start);
    }

    public void delete(int index) {
        throw new UnsupportedOperationException();
    }

    public void delete(String name) {
        throw new UnsupportedOperationException();
    }
}

