/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.def;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class KObjectConverter {
    public static final BigDecimal ZERO_BIGDECIMAL = BigDecimal.valueOf(0L);
    public static final BigInteger ZERO_GIGINTEGER = BigInteger.valueOf(0L);
    public static final Long ZERO_LONG = 0L;
    public static final Integer ZERO_INTEGER = 0;
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Short ZERO_SHORT = Short.valueOf("0");
    public static final Byte ZERO_BYTE = 0;
    private static final Map<Class<?>, Class<?>> primitiveMap = new HashMap(16);

    private static boolean isPrimitiveNumber(Class<?> pcls) {
        return pcls == Integer.TYPE || pcls == Short.TYPE || pcls == Long.TYPE || pcls == Float.TYPE || pcls == Double.TYPE;
    }

    public static boolean isNumber(Class<?> pcls) {
        return Number.class.isAssignableFrom(pcls) || KObjectConverter.isPrimitiveNumber(pcls);
    }

    public static Class<?> getObjectType(Class<?> cls) {
        Class<?> ret = primitiveMap.get(cls);
        return ret == null ? cls : ret;
    }

    public static <T> T toTypedObject(Class<T> cls, Object value) {
        return (T)KObjectConverter._toTypedObject(cls, value);
    }

    public static Object _toTypedObject(Class<?> cls, Object value) {
        if (cls == Long.TYPE || cls == Long.class) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0L;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(String.valueOf(value));
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(String.valueOf(value));
        }
        if (cls == Float.TYPE || cls == Float.class) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return Float.valueOf(0.0f);
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(String.valueOf(value)));
        }
        if (cls == Double.TYPE || cls == Double.class) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0.0;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(String.valueOf(value));
        }
        if (cls == Short.TYPE || cls == Short.class) {
            if (value == null || value instanceof String && ((String)value).length() == 0) {
                return 0;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(String.valueOf(value));
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return value instanceof Boolean ? value : Boolean.valueOf(String.valueOf(value));
        }
        if (cls == Character.TYPE || cls == Character.class) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Character.valueOf(((String)value).charAt(0));
            }
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            if (value instanceof String && ((String)value).length() > 0) {
                return Byte.valueOf((String)value);
            }
        } else {
            if (cls == BigDecimal.class) {
                if (value == null) {
                    return ZERO_BIGDECIMAL;
                }
                if (value instanceof BigDecimal) {
                    return value;
                }
                if (value instanceof Number) {
                    if (value instanceof Float) {
                        return new BigDecimal(Float.toString(((Float)value).floatValue()));
                    }
                    if (value instanceof Double) {
                        return new BigDecimal(Double.toString((Double)value));
                    }
                    return BigDecimal.valueOf(((Number)value).doubleValue());
                }
                return new BigDecimal(String.valueOf(value));
            }
            if (cls == BigInteger.class) {
                if (value == null) {
                    return ZERO_GIGINTEGER;
                }
                if (value instanceof BigInteger) {
                    return value;
                }
                if (value instanceof Number) {
                    return BigInteger.valueOf(((Number)value).longValue());
                }
                return new BigInteger(String.valueOf(value));
            }
        }
        return value;
    }

    static {
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
    }
}

