/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.mate;

import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.script.jsengine.mate.KContextEnv;
import org.mozilla.javascript.ClassShutter;

public class KClassShutter
implements ClassShutter {
    public static final KClassShutter INSTANCE = new KClassShutter();

    public void setAllow(String ... clsPatterns) {
        KContextEnv.getContextEnv().classShutter_allowSet.clear();
        this.addAllow(clsPatterns);
    }

    public void addAllow(String ... clsPatterns) {
        if (clsPatterns != null) {
            Set<Pattern> allowSet = KContextEnv.getContextEnv().classShutter_allowSet;
            for (String clsPattern : clsPatterns) {
                Pattern p = Pattern.compile(clsPattern);
                allowSet.add(p);
            }
        }
    }

    public void setExclude(String ... clsPatterns) {
        KContextEnv.getContextEnv().classShutter_excludeSet.clear();
        this.addExclude(clsPatterns);
    }

    public void addExclude(String ... clsPatterns) {
        if (clsPatterns != null) {
            Set<Pattern> excludeSet = KContextEnv.getContextEnv().classShutter_excludeSet;
            for (String clsPattern : clsPatterns) {
                Pattern p = Pattern.compile(clsPattern);
                excludeSet.add(p);
            }
        }
    }

    private KClassShutter() {
    }

    public final boolean isSafeModel() {
        return KContextEnv.getContextEnv().classShutter_safeModel;
    }

    public void setSafeModel(boolean safeModel) {
        KContextEnv.getContextEnv().classShutter_safeModel = safeModel;
    }

    public boolean visibleToScripts(String fullClassName) {
        boolean ret = this.noLimit(fullClassName);
        return ret;
    }

    private boolean noLimit(String fullClassName) {
        KContextEnv.ContextEnv stack = KContextEnv.getContextEnv();
        if (!stack.classShutter_safeModel) {
            return true;
        }
        for (Pattern p : stack.classShutter_excludeSet) {
            if (!p.matcher(fullClassName).matches()) continue;
            return false;
        }
        for (Pattern p : stack.classShutter_allowSet) {
            if (!p.matcher(fullClassName).matches()) continue;
            return true;
        }
        return false;
    }
}

