/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.script.jsengine.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.script.debug.DebugManager;
import kd.bos.script.jsengine.objects.LogMessage;
import org.mozilla.javascript.Context;

@KSObject(name="Console", namespace="")
public class KConsoleObject
implements ScriptObject {
    public static final String const_name = "console";
    private ConcurrentLinkedQueue<LogMessage> logs = new ConcurrentLinkedQueue();
    private Object lock = new Object();
    private boolean atDebug = DebugManager.currentIsDebugMainThread();

    @Deprecated
    @KSMethod
    public void out(Object value) {
        this.doLog(LogMessage.Level.info, value);
    }

    @KSMethod
    public void info(Object ... msgs) {
        this.doLog(LogMessage.Level.info, msgs);
    }

    @KSMethod
    public void warn(Object ... msgs) {
        this.doLog(LogMessage.Level.warn, msgs);
    }

    @KSMethod
    public void debug(Object ... msgs) {
        this.doLog(LogMessage.Level.debug, msgs);
    }

    @KSMethod
    public void error(Object ... msgs) {
        this.doLog(LogMessage.Level.error, msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KSMethod
    public List<LogMessage> getLogMessages() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<LogMessage> ret = new ArrayList<LogMessage>(this.logs);
            this.logs.clear();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLog(LogMessage.Level level, Object ... msgs) {
        StringBuilder sb = new StringBuilder();
        if (msgs != null && msgs.length > 0) {
            for (int i = 0; i < msgs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Context.toString((Object)msgs[i]));
            }
        }
        String msg = sb.toString();
        if (this.atDebug) {
            Object object = this.lock;
            synchronized (object) {
                this.logs.add(new LogMessage(msg, level));
            }
        }
    }
}

