/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactoryBuilder;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.mservice.center.common.MserviceCenterUtil;

public class CacheHelper {
    private static Map<String, String> localVersion = new ConcurrentHashMap<String, String>(8);
    private static DistributeSessionlessCache cache = CacheFactoryBuilder.newBuilder().build().getDistributeSessionlessCache("mservice-center");

    public static boolean checkVersion(String versionKey) {
        String version = localVersion.get(versionKey);
        String distributeVersion = CacheHelper.hgetVersion(versionKey);
        return version != null && distributeVersion != null && distributeVersion.length() > 0 && version.length() > 0 && version.equals(distributeVersion);
    }

    public static String hgetVersion(String versionKey) {
        byte[] version = cache.hget(versionKey, MserviceCenterUtil.encode("version"));
        return (String)MserviceCenterUtil.decode(version);
    }

    public static void setLocalVersion(String versionKey, String version) {
        localVersion.put(versionKey, version);
    }

    public static String getLocalVersion(String versionKey) {
        return localVersion.get(versionKey);
    }

    public static void hmset(String versionKey, Map<byte[], byte[]> fields, int timeOut) {
        cache.hmset(versionKey, fields, timeOut);
    }

    public static <T> T hget(String versionKey, String field) {
        byte[] version = cache.hget(versionKey, MserviceCenterUtil.encode(field));
        return MserviceCenterUtil.decode(version);
    }

    public static void remove(String versionKey) {
        cache.remove(versionKey);
    }
}

