/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Properties;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.SystemProperties;

class DataSourceConfigFactory {
    private DataSourceConfigFactory() {
    }

    public static DBConfig create(String ip, Integer port, String user, String pwd, DBType dbType, String dataBase) {
        DBConfig config = new DBConfig();
        return config;
    }

    public static DBConfig createFromMCAPI() {
        DBConfig config = new DBConfig();
        return config;
    }

    public static DBConfig createFromUrl(String url) {
        String poolInitialSize;
        String poolMaxActive;
        String poolMaxIdle;
        String poolMaxWait;
        String dbschema;
        String isCluster;
        String loadfactor;
        if (url == null || url.trim().length() == 0) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The value of 'configUrl' is Empty!"});
        }
        url = Encrypters.decode((String)url);
        String[] schemaAndParams = url.split("\\?");
        DataSourceConfigFactory.check(schemaAndParams, 2);
        String[] ipPortAndSchema = schemaAndParams[0].split("/");
        DataSourceConfigFactory.check(ipPortAndSchema, 2);
        DBInstance instance = new DBInstance();
        instance.setDBInsatnce(ipPortAndSchema[1]);
        String[] ipPort = ipPortAndSchema[0].split(":");
        DataSourceConfigFactory.check(ipPort, 2);
        String[] ipInfo = ipPort[0].split("@");
        instance.setDbip(ipInfo[ipInfo.length - 1]);
        instance.setDbport(ipPort[1]);
        String[] params = schemaAndParams[1].split("&");
        StringBuilder builder = new StringBuilder();
        for (String info : params) {
            builder.append(info).append("\n");
        }
        Properties prop = new Properties();
        try (StringReader reader = new StringReader(builder.toString());){
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
        instance.setDbuser(prop.getProperty("user"));
        DataSourceConfigFactory.check(instance.getDbuser());
        String dbPassword = prop.getProperty("password");
        DataSourceConfigFactory.check(dbPassword);
        instance.setDbpassword(Encrypters.decode((String)dbPassword));
        instance.setDbtype(prop.getProperty("dbtype"));
        DataSourceConfigFactory.check(instance.getDbtype());
        String readonly = prop.getProperty("readonly");
        if (readonly != null && readonly.trim().length() > 0) {
            instance.setReadOnly(readonly.trim());
        }
        if ((loadfactor = prop.getProperty("loadfactor")) != null && loadfactor.trim().length() > 0) {
            instance.setLoadFactor(Integer.parseInt(loadfactor.trim()));
        }
        if ((isCluster = prop.getProperty("isCluster")) != null && isCluster.trim().length() > 0) {
            instance.setCluster(Boolean.parseBoolean(isCluster.trim()));
        }
        String dburl = prop.getProperty("dburl");
        if (instance.isCluster() && dburl != null && dburl.trim().length() > 0) {
            instance.setClusterDbUrl(dburl.trim());
        }
        if ((dbschema = prop.getProperty("dbschema")) != null && dbschema.trim().length() > 0) {
            instance.setDbSchema(dbschema.trim());
        }
        Properties properties = new Properties();
        String poolMinIdle = prop.getProperty("poolMinIdle");
        if (poolMinIdle != null && poolMinIdle.trim().length() > 0) {
            properties.setProperty("poolMinIdle", poolMinIdle.trim());
        }
        if ((poolMaxWait = prop.getProperty("poolMaxWait")) != null && poolMaxWait.trim().length() > 0) {
            properties.setProperty("poolMaxWait", poolMaxWait.trim());
        }
        if ((poolMaxIdle = prop.getProperty("poolMaxIdle")) != null && poolMaxIdle.trim().length() > 0) {
            properties.setProperty("poolMaxIdle", poolMaxIdle.trim());
        }
        if ((poolMaxActive = prop.getProperty("poolMaxActive")) != null && poolMaxActive.trim().length() > 0) {
            properties.setProperty("poolMaxActive", poolMaxActive.trim());
        }
        if ((poolInitialSize = prop.getProperty("poolInitialSize")) != null && poolInitialSize.trim().length() > 0) {
            properties.setProperty("poolInitialSize", poolInitialSize.trim());
        }
        instance.setDefaultProperties(properties);
        return DataSourceConfigFactory.getDBConfig(instance);
    }

    public static DBConfig createFromProperty(String paramKey) {
        String url = SystemProperties.getWithEnv((String)paramKey);
        return DataSourceConfigFactory.createFromUrl(url);
    }

    private static void check(Object value) {
        String valueStr;
        if (value == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The datasource config is Error,please Check!"});
        }
        if (value instanceof String && (valueStr = (String)value).trim().length() == 0) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The datasource config is Error,please Check!"});
        }
    }

    private static void check(String[] infos, int size) {
        if (infos == null || infos.length != size) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"The datasource config is Error,please Check!"});
        }
    }

    private static DBConfig getDBConfig(DBInstance instance) {
        try {
            Class<?> aClass = Class.forName("kd.bos.db.datasource.DBConfig");
            Method fromDBInstance = aClass.getDeclaredMethod("fromDBInstance", DBInstance.class, String.class, String.class);
            fromDBInstance.setAccessible(true);
            DBConfig config = (DBConfig)fromDBInstance.invoke(null, instance, null, null);
            fromDBInstance.setAccessible(false);
            return config;
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "get DBConfig error", e);
        }
    }
}

