/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.center.common.DBCongfigTypeEnum;
import kd.bos.mservice.center.common.DBUtil;
import kd.bos.orm.datasync.DtsExcludeSyncContext;

public class MserviceCenterTableInit {
    private static final String ORI_TABLE_SQL = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME=";
    private static final String PROTO_TABLE_SQL = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME=";
    private static AtomicBoolean initDBRegistrySuccess = new AtomicBoolean();
    private static AtomicBoolean initDBConfigSuccess = new AtomicBoolean();

    public static void initDBRegistryTable() {
        if (initDBRegistrySuccess.compareAndSet(false, true)) {
            DBUtil.initDataSouce(DBCongfigTypeEnum.DBREGISTRY, true, null);
            MserviceCenterTableInit.initTable(DBCongfigTypeEnum.DBREGISTRY, "T_CBS_RC_SERVICE", "sql/t_cbs_rc_service.sql");
            MserviceCenterTableInit.initTable(DBCongfigTypeEnum.DBREGISTRY, "T_CBS_LIVINGINSTANCE", "sql/t_cbs_livinginstance.sql");
        }
    }

    public static void initDBConfigTable(String url) {
        if (initDBConfigSuccess.compareAndSet(false, true)) {
            DBUtil.initDataSouce(DBCongfigTypeEnum.DBCONFIG, true, url);
            MserviceCenterTableInit.initTable(DBCongfigTypeEnum.DBCONFIG, "T_CBS_CC_CONFIG", "sql/t_cbs_cc_config.sql");
        }
    }

    private static void initTable(DBCongfigTypeEnum type, String tableName, String sqlFileName) {
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            MserviceCenterTableInit.createTable(type, sqlFileName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "initTable error", (Throwable)e);
        }
    }

    private static void createTable(DBCongfigTypeEnum type, String sqlFileName) throws IOException, SQLException {
        try (InputStream inputStream = MserviceCenterTableInit.class.getClassLoader().getResourceAsStream(sqlFileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                sb.append(line);
            }
            List<String> sqls = Arrays.asList(sb.toString().split(";"));
            ArrayList<Tuple<String, Object[]>> sqlAndParams = new ArrayList<Tuple<String, Object[]>>(sqls.size() - 1);
            for (String sql : sqls) {
                if (sql == null || sql.trim().length() == 0 || sql.equals("\n")) continue;
                sqlAndParams.add((Tuple<String, Object[]>)Tuple.create((Object)sql, null));
            }
            boolean result = DBUtil.executeMultiSql(type, sqlAndParams);
            if (!result) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"create table error"});
            }
        }
    }
}

