/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResultHandler.class);

    T handle(ResultSet resultSet, Connection connection, Statement statement) throws SQLException {
        T result = this.doHandle(resultSet);
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error("close resultset error", (Throwable)e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.error("close statement error", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error("close connection error", (Throwable)e);
            }
        }
        return result;
    }

    protected abstract T doHandle(ResultSet var1) throws SQLException;
}

