/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.config.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.config.client.configcenter.KConfigCenterConfigurationSource;
import kd.bos.config.client.configcenter.KConfigCenterSource;
import kd.bos.mservice.center.config.db.ConfigNotifier;
import kd.bos.mservice.center.config.db.common.ConfigDTO;
import kd.bos.mservice.center.config.db.task.DBConfigTaskStarter;
import kd.bos.mservice.center.config.db.util.ConfigCacheHelper;
import kd.bos.mservice.center.config.db.util.ConfigDBHelper;
import kd.bos.mservice.center.config.db.util.DBConfigCenterUtil;

public class DBConfigCenterSource
implements KConfigCenterSource {
    private String appName;
    private String clusterName;
    private String configType;

    public void init(String url, String clusterName, String configAppName, String configType) {
        this.appName = configAppName;
        this.clusterName = clusterName;
        this.configType = configType;
        DBConfigTaskStarter.startInstanceStatusMangeTask(clusterName);
    }

    public Map<String, Object> getData() {
        List<ConfigDTO> configsFromLocal = ConfigCacheHelper.getConfigsFromLocal(this.clusterName, this.appName);
        ArrayList<ConfigDTO> returnDTO = new ArrayList<ConfigDTO>(2);
        if (configsFromLocal != null && configsFromLocal.size() > 0) {
            for (ConfigDTO dto : configsFromLocal) {
                if (!dto.getConfigType().toLowerCase(Locale.ENGLISH).equals(this.configType.toLowerCase(Locale.ENGLISH))) continue;
                returnDTO.add(dto);
            }
            return DBConfigCenterUtil.getKeyValues(returnDTO);
        }
        List<ConfigDTO> configDTOS = ConfigDBHelper.queryNotDeletedConfig(this.clusterName, this.appName);
        if (configDTOS != null && configDTOS.size() > 0) {
            ConfigCacheHelper.updateLocalConfigs(this.clusterName, this.appName, configDTOS);
            for (ConfigDTO dto : configDTOS) {
                if (!dto.getConfigType().toLowerCase(Locale.ENGLISH).equals(this.configType.toLowerCase(Locale.ENGLISH))) continue;
                returnDTO.add(dto);
            }
        }
        return DBConfigCenterUtil.getKeyValues(returnDTO);
    }

    public void registListener(KConfigCenterConfigurationSource.CallBackEvent callBackEvent) {
        ConfigNotifier.registerListener(callBackEvent);
    }

    public void close() {
        ConfigCacheHelper.clearConfig(this.clusterName, this.appName);
        ConfigNotifier.unregisterListener();
    }
}

